
#include <string>
#include <sstream>

struct InfoEventReport {
	enum TYPE {
		TYPE_VOID = 0,
		TYPE_UNKNOWN = 1,
		TYPE_WORKSITE_SCOUTED,
		TYPE_WORKSITE_REACHED,
		TYPE_WORKSITE_MISSING,
		TYPE_WORKSITE_PAUSED,
		TYPE_WORKSITE_ABANDONED,
		TYPE_ROBOT_RECRUITED,
		TYPE_WORKSITE_SWITCHED,
		TYPE_WORKSITE_STARTED,
		TYPE_REWARD_STARTED,
		TYPE_REWARD_FINISHED,
		TYPE_REWARD_RECEIVED
	} type;

	int worksiteId;
	int recruiterId;
	int globalTime;

	int robotId;

	InfoEventReport() {
		type = TYPE_VOID;
		worksiteId = -1;
		recruiterId = -1;
		globalTime = -1;
		robotId = -1;
	}

	bool GetIsTheSameAs(InfoEventReport report_) {
		return (report_.robotId == robotId && report_.type == type && report_.worksiteId == worksiteId && report_.recruiterId == recruiterId && report_.globalTime == globalTime);
	}

	std::string GetDescriptionString() {
		std::ostringstream s;
		switch (type) {
			case TYPE_VOID: s << "VOID"; break;
			case TYPE_UNKNOWN: s << "UNKNOWN"; break;
			case TYPE_WORKSITE_SCOUTED: s << "SITE_SCOUTED"; break;
			case TYPE_WORKSITE_REACHED: s << "SITE_REACHED"; break;
			case TYPE_WORKSITE_MISSING: s << "SITE_MISSING"; break;
			case TYPE_WORKSITE_PAUSED: s << "SITE_PAUSED"; break;
			case TYPE_WORKSITE_ABANDONED: s << "SITE_ABANDONED"; break;
			case TYPE_ROBOT_RECRUITED: s << "ROBOT_RECRUITED"; break;
			case TYPE_WORKSITE_SWITCHED: s << "SITE_SWITCHED"; break;
			case TYPE_WORKSITE_STARTED: s << "SITE_STARTED"; break;
			case TYPE_REWARD_STARTED: s << "REWARD_STARTED"; break;
			case TYPE_REWARD_FINISHED: s << "REWARD_FINISHED"; break;
			case TYPE_REWARD_RECEIVED: s << "REWARD_RECEIVED"; break;
		}
		s << " t=" << globalTime << " worksite id: " << worksiteId << "  recruiter id:" << recruiterId;
		return s.str();

	}

	std::string GetTypeDescriptionString() {
		switch (type) {
			case TYPE_VOID: return "VOID";
			case TYPE_UNKNOWN: return "UNKNOWN";
			case TYPE_WORKSITE_SCOUTED: return "SITE_SCOUTED";
			case TYPE_WORKSITE_REACHED: return "SITE_REACHED";
			case TYPE_WORKSITE_MISSING: return "SITE_MISSING";
			case TYPE_WORKSITE_PAUSED: return "SITE_PAUSED";
			case TYPE_WORKSITE_ABANDONED: return "SITE_ABANDONED";
			case TYPE_ROBOT_RECRUITED: return "ROBOT_RECRUITED";
			case TYPE_WORKSITE_SWITCHED: return "SITE_SWITCHED";
			case TYPE_WORKSITE_STARTED: return "SITE_STARTED";
			case TYPE_REWARD_STARTED: return "REWARD_STARTED";
			case TYPE_REWARD_FINISHED: return "REWARD_FINISHED";
			case TYPE_REWARD_RECEIVED: return "REWARD_RECEIVED";
		}
		return "VOID";
	}

};
