#ifndef COMMON_MATH_HELPERS
#define COMMON_MATH_HELPERS

#include <stdlib.h>
#include <math.h>


inline double mathHelpers_generateRand(double min_, double max_) {
	return (max_ - min_) * ( (double)rand() / (double)RAND_MAX ) + min_;
}


/**
 * Get a random number from normal distribution
 */
inline double mathHelpers_generateRandGauss (double sigma_) {
	double v1,v2,s;

	do {
		v1 = 2.0 * ((double) rand()/RAND_MAX) - 1;
		v2 = 2.0 * ((double) rand()/RAND_MAX) - 1;

		s = v1*v1 + v2*v2;
	} while ( s >= 1.0 );

	if (s == 0.0)
		return 0.0;
	else
		return sigma_*(v1*sqrt(-2.0 * log(s) / s));
}

#endif
