#include <stdlib.h>
#include <IPCInterface.h>
#include <cpp_observer/ViconPosition.h>
#include "ros/ros.h"
#include "vector"
#include "string"
#include "sstream"
#include "EpuckPositionSubscriberTopic.h"

void EpuckPositionSubscriberTopic::UpdatePositionCallback(const cpp_observer::ViconPosition::ConstPtr& msg){
	X = msg->X.data;
	Y = msg->Y.data;
	A = msg->A.data;
	worksite1Id = msg->worksite1Id.data;
	worksite1X = msg->worksite1X.data;
	worksite1Y = msg->worksite1Y.data;
	resourcePortionId = msg->resourcePortionId.data;
	resourceReceived = msg->resourceReceived.data;
	resourceLeft = msg->resourceLeft.data;
	globalTime = msg->globalTime.data;
	//std::cout << " UpdatePositionCallback: t=" << globalTime << " X=" << X << "  Y=" << Y << "A=" << A << " portionid=" << resourcePortionId << " resource=" << resourceReceived << " res left=" << resourceLeft << std::endl;
}

int EpuckPositionSubscriberTopic::GetPositionX(){
  return X;
}

int EpuckPositionSubscriberTopic::GetPositionY(){
  return Y;
}

int EpuckPositionSubscriberTopic::GetPositionA(){
	return A;
}

int EpuckPositionSubscriberTopic::GetWorksite1Id() {
	return worksite1Id;
}

int EpuckPositionSubscriberTopic::GetWorksite1X() {
	return worksite1X;
}

int EpuckPositionSubscriberTopic::GetWorksite1Y() {
	return worksite1Y;
}

int EpuckPositionSubscriberTopic::GetResourceReceived() {
	return resourceReceived;
}

int EpuckPositionSubscriberTopic::GetResourcePortionId() {
	return resourcePortionId;
}

int EpuckPositionSubscriberTopic::GetResourceLeft() {
	return resourceLeft;
}

int EpuckPositionSubscriberTopic::GetGlobalTime() {
	return globalTime;
}



void EpuckPositionSubscriberTopic::SetTopicName(std::string SubscriberTopicName){
  this->SubscriberTopicName = SubscriberTopicName;
}

std::string* EpuckPositionSubscriberTopic::GetTopicName(){
  return &SubscriberTopicName;
}

void EpuckPositionSubscriberTopic::SetIP(std::string IP){
  this->IP = IP;
}

std::string* EpuckPositionSubscriberTopic::GetIP(){
  return &IP;
}
