#ifndef IPCINTERFACE_H
#define IPCINTERFACE_H

#ifndef STRING_H
#include <string>
#endif

#ifndef IPC_HH
#include <ipc.hh>
#endif


class ELolMessage;
class IPCInterface {

 private :

  int hostPortNo;
  std::string hostIpAddress;

  // IPC Handler
  IPC::IPC ipc;

  int currentSenderID;
  int resourceRequestData[3];
  int infoEventReportData[5];
  int robotCommData[4];


 public :
   
  IPCInterface(std::string IPAddress,int Port);
  ~IPCInterface();

  static void ServerConnection(const ELolMessage*msg, void *conn, void *ptr);


  void InitializeServer();

  int* GetCurrentSenderID();
  int* GetResourceRequestArray();
  int* GetInfoEventReportArray();
  int* GetRobotCommDataArray();

  void SendRobotPosition(const char* addr, int X, int Y, int A, int worksite1Id, int worksite1X, int worksite1Y, int portionId, int resourceReceived, int resourceLeft, int globalTime);
  void SendRobotCommunication(const char* addr, int worksiteId, int worksiteX, int worksiteY, int recruiterId);



};
#endif
