/*
 * LocalBroadcasterActionController.cpp
 *
 *  Created on: 22 May 2017
 *      Author: lenka
 */


#include <stdint.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <iostream>

#include <epuck.hh>
#include <constants.h>
#include <Vector2D.h>
#include <IPCInterface.h>
#include <PathPlanner.h>

#include "LocalBroadcasterActionController.h"

LocalBroadcasterActionController::LocalBroadcasterActionController(Robot* robot_, PathPlanner* pathPlanner_, EPuckBoardController* epuckBoardController_) :
	BaseActionController(robot_,pathPlanner_,epuckBoardController_) {

	std::cout << "Local broadcaster action controller created" << std::endl;

}

LocalBroadcasterActionController::~LocalBroadcasterActionController() {

}

BaseActionController::STATE LocalBroadcasterActionController::ProcessCurrentState(uint64_t timeStamp_) {
	BaseActionController::STATE stateToReturn =  BaseActionController::ProcessCurrentState(timeStamp_);

	//-- recruit if near worksite
	if (targetWorksiteInfo.id > 0 && rewardReceived > 0 && pathPlanner->GetDistanceToWorksite() <= robot->lbNearWorksiteD ) {
		robot->ipcToComm->SendRecruitmentSignal(targetWorksiteInfo.id, targetWorksiteInfo.posX, targetWorksiteInfo.posY);
	} else {
		robot->ipcToComm->SendRecruitmentSignal(-1,-1,-1);
	}
	return stateToReturn;
}

void LocalBroadcasterActionController::Scout() {
	BaseActionController::Scout();
	if (currentState == BaseActionController::STATE_SCOUTING) {
		BaseActionController::ProcessRecruitmentSignals();
	}
}

void LocalBroadcasterActionController::ProcessWorksite() {
	BaseActionController::ProcessWorksite();



}
