/*
 * ReportTestActionController.cpp
 *
 *  Created on: 9 May 2017
 *      Author: lenka
 */

#include <stdint.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <iostream>

#include <epuck.hh>
#include <IPCInterface.h>
#include "ReportTestActionController.h"

ReportTestActionController::ReportTestActionController(Robot* robot_, PathPlanner* pathPlanner_, EPuckBoardController* epuckBoardController_) :
	BaseActionController(robot_,pathPlanner_,epuckBoardController_) {

	std::cout << "Report test action controller created" << std::endl;

	lastReportGlobalTime = -999;
	numOfReportsSent = 0;

}


ReportTestActionController::~ReportTestActionController() {

}

BaseActionController::STATE ReportTestActionController::ProcessCurrentState(uint64_t timeStamp_) {
	//-- every new second, add one report
	//if (ipcVicon->GetGlobalTime() > 30 && ipcVicon->GetGlobalTime() != lastReportGlobalTime && numOfReportsSent < 100) {
	if (timeStamp_ % 10 == 0 && numOfReportsSent < 100) {
		NewInfoEventReport((numOfReportsSent+1),InfoEventReport::TYPE_WORKSITE_SCOUTED,-1,-1);
		lastReportGlobalTime = robot->ipcVicon->GetGlobalTime();
		numOfReportsSent++;
	}

	currentNavigationVector->x = 0;
	currentNavigationVector->y = 0;

	BaseActionController::SendReportsToServer();

	return BaseActionController::STATE_SCOUTING;
}

