import crData;
import pyCreeper;
pyCreeper.crGraphs.DEBUG_LEVEL = 0;

import constants;
import numpy;


experimentName = "params_report"
eventsStartAt = 31;
numOfEventsRobotSends = 100;
eventNoXAxisValues = [];
for i in range(numOfEventsRobotSends):
    if (i%10 == 0):
        eventNoXAxisValues.append("{}".format(i))
    else:
        eventNoXAxisValues.append("");

rstVals = [1,10,50];
nrVals = [1,10];
numRuns = 10;

for nr in range(len(nrVals)):
    nrVal = nrVals[nr];

    eventDelays = [[[] for runNo in range(numRuns)] for rst in range(len(rstVals))];

    eventMisses = [[0 for runNo in range(numRuns)] for rst in range(len(rstVals))]; #in percentage out of total events

    for rst in range(len(rstVals)):
        rstVal = rstVals[rst];

        eventDelaysOverTime=[[] for i in range(numOfEventsRobotSends)];

        for runNo in range(numRuns):
            runData = crData.fileToArray((constants.DATA_PATH+"/{}_rst{}/NR{}_TA_heap1-5000_S/run{}_infoEvents.txt").format(experimentName, rstVal,nrVal,runNo),"\t", True);

            expectedNumOfEvents = numOfEventsRobotSends*nrVal;
            delaysInThisRun=[];
            numOfEvents = 0;

            #-- go through each row of run data
            for i in range(len(runData)):
                eventType = runData[i][1];
                time = runData[i][0];
                receivedTime = runData[i][8];
                if (eventType == constants.E_SITE_SCOUTED):
                    numOfEvents += 1;
                    timeIndex = int(time - eventsStartAt);
                    delay = receivedTime - time;
                    delaysInThisRun.append(delay);

                    if (timeIndex < numOfEventsRobotSends):
                        eventDelaysOverTime[timeIndex].append(delay);

                        #print("time {} timeIndex {} delay {} all {}".format(time,timeIndex,delay,eventDelaysOverTime[timeIndex]));

            eventDelays[rst][runNo] = numpy.median(delaysInThisRun);

            eventMisses[rst][runNo] = (1 - numOfEvents/expectedNumOfEvents) * 100;
            #print(("num events {} expected {} % misses {}").format(numOfEvents, expectedNumOfEvents, eventMisses[rst][runNo]));

        #print(eventDelaysOverTime);
        plotFilePath = "{}/{}/eventDelaysOverTime_NR{}_rst{}.png".format(constants.PLOTS_PATH,experimentName,nrVal, rstVal);
        pyCreeper.crGraphs.createLinePlot([eventDelaysOverTime],yLabel_="Event delay [s]", xLabel_="Message number", xTickLabels_=eventNoXAxisValues,showConfidenceIntervals_=True, filePath_=plotFilePath, size_=(20,5), gridType_=pyCreeper.crGraphs.GRID_TYPE.MAJOR, markerSize_=5);

    #print(eventMisses);
    plotFilePath = "{}/{}/eventMisses_NR{}.png".format(constants.PLOTS_PATH,experimentName,nrVal);
    pyCreeper.crGraphs.createLinePlot([eventMisses],yLabel_="% event misses", xLabel_="report send trials", xTickLabels_=rstVals, showBoxPlots_=True, filePath_=plotFilePath);

    #--

    print(eventDelays);
    plotFilePath="{}/{}/eventDelays_NR{}.png".format(constants.PLOTS_PATH,experimentName,nrVal);
    pyCreeper.crGraphs.createLinePlot([eventDelays],yLabel_="Avg event delay [s]",xLabel_="report send trials", xTickLabels_=rstVals,showBoxPlots_=True,filePath_=plotFilePath);




