#####
# SHORTCUTS USED:
#
# wsr = worksite sense range
# gpev = global position error variance
#
####

import pyCreeper;
pyCreeper.crGraphs.DEBUG_LEVEL = 0;

import analysis;

import icrfAnalyser;
icrfAnalyser.EVENTS_RECORD_HAS_ZERO_BASED_SITE_NUMBERING = False;
analysis.RECALC_ICR_CACHE = False;
analysis.RECALC_ICR_SECONDARY_CACHE = True;

import visualisation;
from helpers import dataFormatHelpers;
from helpers import helpers;

import constants;
import numpy;

constants.USING_SIMULATION_RESULTS = False;

nrVals = [5];

experimentNamePrefix = "static_wsr2500_gpev2000"
#experimentNamePrefix = "static_wsr2500"

controllers = ['Solitary','Local broadcaster'];
envs = ['Heap1-7000','Heap3-7000','Scatter12-7000','Heap1-14000','Heap3-14000','Scatter12-14000'];
numRuns = 10;

#controllers = ['Local broadcaster'];
#controllers = ['Solitary'];
#envs = ['Heap3-7000'];
#envs = ['Heap1-7000','Heap3-7000','Scatter12-7000'];
#numRuns = 1;

if (constants.USING_SIMULATION_RESULTS):
    numRuns = 50;

DO_DATA_CLEANING = False;
DO_COMPLETION_TIME = False;
DO_COMPLETION_TIME_AVERAGE = False;
DO_COMPLETION_TIME_VARIANCE = False;

DO_ICR_ANALYSIS = False;
DO_ICR_ANALYSIS_OVER_TIME = False;

DO_ICR_SECONDARY_ANALYSIS = True;

CHECK_NUM_RUNS_WITH_FAILUERS = False;
CHECK_TOTAL_ROBOT_FAILURE_TIME = False;

for nr in range(len(nrVals)):
    nrVal = nrVals[nr];

    results_completionTime = [[[] for j in range(len(envs))] for k in range(len(controllers))];
    results_timeOfRobotFailures = [[[0 for i in range(numRuns)] for j in range(len(envs))] for c in range(len(controllers))];
    results_numRunsWithRobotFailuers = [[0 for j in range(len(envs))] for c in range(len(controllers))];
    results_completionTimeVariance = [[0 for j in range(len(envs))] for k in range(len(controllers))];


    results_icrDataOverTime = [[[] for j in range(len(envs))] for k in range(len(controllers))];
    results_icrData = [[[] for j in range(len(envs))] for k in range(len(controllers))];
    results_icrSecondaryData = [[[] for j in range(len(envs))] for k in range(len(controllers))];

    for c in range(len(controllers)):
        controllerVal = controllers[c];
        print(controllerVal);

        for env in range(len(envs)):
            envName = envs[env];
            print(envName);
            dataPathPrefix ="{}/NR{}_FOR_{}_{}".format(experimentNamePrefix, nrVal, dataFormatHelpers.getEnvironmentPathName(envName), dataFormatHelpers.getControllerPathName(controllerVal));

            if (DO_DATA_CLEANING):
                analysis.cleanInfoEventsDataForRuns(dataPathPrefix, numRuns);

            if (DO_COMPLETION_TIME or DO_COMPLETION_TIME_VARIANCE or DO_COMPLETION_TIME_AVERAGE):
                results_completionTime[c][env]= analysis.getCompletionTimes(dataPathPrefix, numRuns);

                if (DO_COMPLETION_TIME_VARIANCE):
                    results_completionTimeVariance[c][env] = numpy.std(results_completionTime[c][env]);

            if (DO_ICR_ANALYSIS_OVER_TIME):
                results_icrDataOverTime[c][env] = analysis.getICRDataOverTime(dataPathPrefix, numRuns, nrVal, dataFormatHelpers.getMaxTimeForExperiment(experimentNamePrefix), dataFormatHelpers.getRewardGainRateForExperiment(experimentNamePrefix));
                    #visualisation.visualiseICRDataOverTime(icrData);

            if (CHECK_NUM_RUNS_WITH_FAILUERS or CHECK_TOTAL_ROBOT_FAILURE_TIME):
                consistancyData = analysis.getDataConsistencyInfo(dataPathPrefix, numRuns, nrVal);
                results_numRunsWithRobotFailuers[c][env] = consistancyData[0]
                results_timeOfRobotFailures[c][env] = consistancyData[3];

            if (DO_ICR_ANALYSIS):
                #analysis.INFO_GAIN_COMPRESSION_TIME_INTERVAL = 20;
                results_icrData[c][env] = analysis.getICRData(dataPathPrefix, numRuns, nrVal, dataFormatHelpers.getMaxTimeForExperiment(experimentNamePrefix), 1.0)

            if (DO_ICR_SECONDARY_ANALYSIS):
                results_icrSecondaryData[c][env] = analysis.getICRSecondaryData(dataPathPrefix, numRuns, nrVal, dataFormatHelpers.getMaxTimeForExperiment(experimentNamePrefix));


    #print(results_completionTime);


    #-- visualisation
    markers, lineStyles = visualisation.getPlotStylesForControllers(controllers,[experimentNamePrefix for x in range(len(controllers))]);

    if (DO_COMPLETION_TIME):
        plotFilePath="{}/{}/completionTime_NR{}".format(constants.PLOTS_PATH,experimentNamePrefix,nrVal);
        if (constants.USING_SIMULATION_RESULTS):
            plotFilePath += "_sim";
        plotFilePath += ".png";
        yMin = 4;
        yMax = 16;
        if ('gpev2000' in experimentNamePrefix):
            yMin = 4;
            yMax = 28;
        pyCreeper.crGraphs.createLinePlot(results_completionTime, markers_=markers, doWilcoxon_=True, xAxisGroupSize_=3, lineWidth_=2, lineStyles_=lineStyles, yTicksStep_=2, yMin_=yMin,yMax_=yMax, yLabel_="Completion time [mins]", xTickLabels_=envs, legendLabels_=controllers, showBoxPlots_=True, filePath_=plotFilePath, size_=(15,5), gridType_=pyCreeper.crGraphs.GRID_TYPE.MAJOR, markerSize_=10);

    if (DO_COMPLETION_TIME_AVERAGE):
        plotFilePath="{}/{}/completionTimeAvg_NR{}".format(constants.PLOTS_PATH,experimentNamePrefix,nrVal);
        if (constants.USING_SIMULATION_RESULTS):
            plotFilePath += "_sim";
        plotFilePath += ".png";
        yMin = 4;
        yMax = 16;
        if ('gpev2000' in experimentNamePrefix):
            yMin = 4;
            yMax = 28;
        pyCreeper.crGraphs.createLinePlot(results_completionTime, markers_=markers, doWilcoxon_=True, xAxisGroupSize_=3, lineWidth_=2, lineStyles_=lineStyles, yTicksStep_=2, yMin_=yMin,yMax_=yMax, yLabel_="Completion time [mins]", xTickLabels_=envs, legendLabels_=controllers, showAverages_=False, showConfidenceIntervals_=True, filePath_=plotFilePath, size_=(15,5), gridType_=pyCreeper.crGraphs.GRID_TYPE.MAJOR, markerSize_=10);


    if (CHECK_NUM_RUNS_WITH_FAILUERS):
        plotFilePath = "{}/{}/numRunsWithFailures_NR{}.png".format(constants.PLOTS_PATH, experimentNamePrefix, nrVal);
        pyCreeper.crGraphs.createLinePlot(results_numRunsWithRobotFailuers,yLabel_="% of runs with robot failures", xTickLabels_=envs,legendLabels_=controllers, yMin_=0,yMax_=50, showAverages_=True, filePath_=plotFilePath, size_=(20,5), gridType_=pyCreeper.crGraphs.GRID_TYPE.MAJOR, markerSize_=15, lineWidth_=0);

    if (CHECK_TOTAL_ROBOT_FAILURE_TIME):
        #print(results_timeOfRobotFailures);
        plotFilePath = "{}/{}/timeOfRobotFailures_NR{}.png".format(constants.PLOTS_PATH, experimentNamePrefix, nrVal);
        pyCreeper.crGraphs.createLinePlot(results_timeOfRobotFailures, yLabel_="% time of robot failures", xTickLabels_=envs,legendLabels_=controllers, yMin_=0,yMax_=8, yTicksStep_=2, showAverages_=True, showConfidenceIntervals_=True, filePath_=plotFilePath, size_=(20, 5), gridType_=pyCreeper.crGraphs.GRID_TYPE.MAJOR, markerSize_=15, lineWidth_=0);

    if (DO_COMPLETION_TIME_VARIANCE):
        plotFilePath="{}/{}/completionTimeVariance_NR{}".format(constants.PLOTS_PATH,experimentNamePrefix,nrVal);
        if (constants.USING_SIMULATION_RESULTS):
            plotFilePath += "_sim";
        plotFilePath += ".png";
        yMin = 0;
        yMax = 8;
        print(results_completionTimeVariance);
        pyCreeper.crGraphs.createLinePlot(results_completionTimeVariance, markers_=markers, doWilcoxon_=True, lineWidth_=0, lineStyles_=lineStyles, yTicksStep_=2, yMin_=yMin,yMax_=yMax, yLabel_="Completion time [mins] variance", xTickLabels_=envs, legendLabels_=controllers, filePath_=plotFilePath, size_=(15,5), gridType_=pyCreeper.crGraphs.GRID_TYPE.MAJOR, markerSize_=10);


    if (DO_ICR_ANALYSIS_OVER_TIME):
        for c in range(len(controllers)):
            controllerVal = controllers[c];
            for env in range(len(envs)):
                envName = envs[env];
                plotFilePath="{}/{}/overTime_*GRAPH_TYPE*_NR{}_{}_{}".format(constants.PLOTS_PATH,experimentNamePrefix,nrVal,envName,dataFormatHelpers.getControllerPathName(controllerVal));
                if (constants.USING_SIMULATION_RESULTS):
                    plotFilePath+="_sim";
                plotFilePath+="_{}runs.png".format(numRuns);
                visualisation.visualiseICRDataOverTime(results_icrDataOverTime[c][env],plotFilePath);

    if (DO_ICR_ANALYSIS):
        plotFilePath="{}/{}/*GRAPH_TYPE*_NR{}.png".format(constants.PLOTS_PATH,experimentNamePrefix,nrVal);
        visualisation.visualiseICRData(results_icrData,plotFilePath,controllers,envs,markers,lineStyles);

    if (DO_ICR_SECONDARY_ANALYSIS):
        plotFilePath="{}/{}/*GRAPH_TYPE*_NR{}.png".format(constants.PLOTS_PATH,experimentNamePrefix,nrVal);
        visualisation.visualiseICRSecondaryData(results_icrSecondaryData,plotFilePath,controllers,envs,markers,lineStyles);