#####
# wsr - worksite sense range
#

import crData;
import pyCreeper;
pyCreeper.crGraphs.DEBUG_LEVEL = 0;

import analysis;
import visualisation;

import constants;
import numpy;

constants.USING_SIMULATION_RESULTS = False;

experimentNamePrefix = "static_wsr2500"
controller = 'LB_commD12500';
#controller = 'S';
noizeVals = ['','_gpev2000'] #_gpev2000
legendLabels = ['normal noize','std=0.2m'];

#envs = ['heap1-7000','heap3-7000','scatter10-7000','heap3-14000','scatter10-14000'];
envs = ['heap1-7000','heap3-7000','scatter12-7000','heap1-14000','heap3-14000','scatter12-14000'];
#envs = ['scatter12-7000','scatter12-7000'];
#envs = ['heap3-14000','scatter12-7000'];
nrVals = [5];
numRuns = 10;

if (constants.USING_SIMULATION_RESULTS):
    numRuns = 50;

DO_COMPLETION_TIME = False;
DO_ICR_ANALYSIS = False;

CHECK_NUM_RUNS_WITH_FAILUERS = True;
CHECK_TOTAL_ROBOT_FAILURE_TIME = True;

for nr in range(len(nrVals)):
    nrVal = nrVals[nr];

    results_completionTime = [[[0 for i in range(numRuns)] for j in range(len(envs))] for k in range(len(noizeVals))];
    results_timeOfRobotFailures = [[[0 for i in range(numRuns)] for j in range(len(envs))] for c in range(len(noizeVals))];
    results_numRunsWithRobotFailuers = [[0 for j in range(len(envs))] for c in range(len(noizeVals))];

    for n in range(len(noizeVals)):
        noizeVal = noizeVals[n];
        print("nozie: " + str(noizeVal));

        for env in range(len(envs)):
            envName = envs[env];
            print(envName);



            icrData = [];
            for runNo in range(numRuns):
                runDataPathPrefix = "{}{}/NR{}_FOR_{}_{}/run{}".format(experimentNamePrefix,noizeVal, nrVal, envName, controller, runNo);
                if (DO_COMPLETION_TIME):
                    completionTime = analysis.getRunCompletionTime(runDataPathPrefix, targetResourceCollected_=100);
                    results_completionTime[n][env][runNo] = completionTime;
                    print(completionTime);

                if (DO_ICR_ANALYSIS):
                    icrData.append(analysis.getICRData(runDataPathPrefix, nrVal, 500));
                    #visualisation.visualiseICRDataOverTime(icrData);

                if (CHECK_NUM_RUNS_WITH_FAILUERS or CHECK_TOTAL_ROBOT_FAILURE_TIME):
                    consistancyData = analysis.getDataConsistancyInfo(runDataPathPrefix, nrVal);
                    results_timeOfRobotFailures[n][env][runNo] = consistancyData[2];
                    if (consistancyData[0] == False):
                        results_numRunsWithRobotFailuers[n][env] = 999;
                    elif (consistancyData[1] > 0):
                        results_numRunsWithRobotFailuers[n][env] += 1; #(1.0 / numRuns) * 100;

            #if (DO_ICR_ANALYSIS):
            #   plotFilePath="{}/{}/costsOverTime_{}_NR{}_{}".format(constants.PLOTS_PATH,experimentNamePrefix,controllerVal,nrVal,envName);
            #    if (constants.USING_SIMULATION_RESULTS):
            #        plotFilePath+="_sim";
            #    plotFilePath+=".png";
            #    visualisation.visualiseICRDataOverTime(icrData,plotFilePath);
    #print(results_completionTime);



    markers, lineStyles = visualisation.getPlotStylesForControllers([controller for x in range(len(noizeVals))],noizeVals);

    if (DO_COMPLETION_TIME):
        print(results_completionTime);
        plotFilePath="{}/{}_noize/completionTime_NR{}_{}".format(constants.PLOTS_PATH,experimentNamePrefix,nrVal,controller);
        if (constants.USING_SIMULATION_RESULTS):
            plotFilePath += "_sim";
        plotFilePath += ".png";
        plotFilePath = "";
        pyCreeper.crGraphs.createLinePlot(results_completionTime, yTicksStep_=2, yMin_=4,yMax_=25, yLabel_="Completion time [mins]", xTickLabels_=envs, legendLabels_=legendLabels, showBoxPlots_=True, filePath_=plotFilePath, size_=(20,5), gridType_=pyCreeper.crGraphs.GRID_TYPE.MAJOR, markerSize_=5, lineWidth_=0, markers_=markers, lineStyles_=lineStyles);


    if (CHECK_NUM_RUNS_WITH_FAILUERS):
        #print(results_numRunsWithRobotFailuers);
        plotFilePath = "{}/{}/numRunsWithFailures_NR{}.png".format(constants.PLOTS_PATH, experimentNamePrefix, nrVal);
        plotFilePath = ""
        pyCreeper.crGraphs.createLinePlot(results_numRunsWithRobotFailuers,yLabel_="% of runs with robot failures", xTickLabels_=envs,legendLabels_=legendLabels, yMin_=0,yMax_=10, yTicksStep_=10, showAverages_=True, filePath_=plotFilePath, size_=(20,5), gridType_=pyCreeper.crGraphs.GRID_TYPE.MAJOR, markerSize_=15, lineWidth_=0);

    if (CHECK_TOTAL_ROBOT_FAILURE_TIME):
        #print(results_timeOfRobotFailures);
        plotFilePath = "{}/{}/timeOfRobotFailures_NR{}.png".format(constants.PLOTS_PATH, experimentNamePrefix, nrVal);
        plotFilePath = ""
        pyCreeper.crGraphs.createLinePlot(results_timeOfRobotFailures, yLabel_="% time of robot failures", xTickLabels_=envs,legendLabels_=legendLabels, yMin_=0,yMax_=8, yTicksStep_=1, showAverages_=True, showConfidenceIntervals_=True, filePath_=plotFilePath, size_=(20, 5), gridType_=pyCreeper.crGraphs.GRID_TYPE.MAJOR, markerSize_=15, lineWidth_=0);


