#####
# wsr - worksite sense range
#

import pyCreeper;
pyCreeper.crGraphs.DEBUG_LEVEL = 0;

import analysis;
import visualisation;
from helpers import dataFormatHelpers;

import constants;
import numpy;

constants.USING_SIMULATION_RESULTS = False;

controllers = ['Solitary','Local Broadcaster'];

noizeVals = ['','_gpev2000'] #_gpev2000

envs = ['Heap1-7000','Heap3-7000','Scatter12-7000','Heap1-14000','Heap3-14000','Scatter12-14000'];

nrVals = [5];
numRuns = 10;

if (constants.USING_SIMULATION_RESULTS):
    numRuns = 50;

DO_COMPLETION_TIME_AVERAGE_DIFF = True;
DO_COMPLETION_TIME_MEDIAN_DIFF = False;
DO_COMPLETION_TIME_VARIANCE_DIFF = False;

DO_CU_DIFF = False;
DO_CU_VARIANCE_DIFF = False;

DO_CM_DIFF = False;
DO_CD_DIFF = False;


DO_UNEMPLOYMENT_RATE_DIFF = False;
DO_UNEVEN_EMPLOYMENT_RATE_DIFF = False;
DO_FORAGING_TRAVEL_TIME_DIFF = False;

for nr in range(len(nrVals)):
    nrVal = nrVals[nr];


    results_completionTimeAverageDiff = [[0 for j in range(len(envs))] for k in range(len(controllers))];
    results_completionTimeMedianDiff = [[0 for j in range(len(envs))] for k in range(len(controllers))];
    results_completionTimeVarianceDiff = [[0 for j in range(len(envs))] for k in range(len(controllers))];
    results_cuAverageDiff = [[0 for j in range(len(envs))] for k in range(len(controllers))];
    results_cuVarianceDiff = [[0 for j in range(len(envs))] for k in range(len(controllers))];
    results_cmDiff = [[0 for j in range(len(envs))] for k in range(len(controllers))];
    results_cdDiff = [[0 for j in range(len(envs))] for k in range(len(controllers))];

    results_unemploymentRateDiff = [[0 for j in range(len(envs))] for k in range(len(controllers))];
    results_unevenEmploymentRateDiff = [[0 for j in range(len(envs))] for k in range(len(controllers))];
    results_foragingTravelTimeDiff = [[0 for j in range(len(envs))] for k in range(len(controllers))];


    for c in range(len(controllers)):
        controllerVal = controllers[c];
        print(controllerVal);

        for env in range(len(envs)):
            envName = envs[env];
            print(envName);

            if (DO_COMPLETION_TIME_AVERAGE_DIFF or DO_COMPLETION_TIME_MEDIAN_DIFF or DO_COMPLETION_TIME_VARIANCE_DIFF):
                runDataPathPrefix = "static_wsr2500/NR{}_FOR_{}_{}".format(nrVal, dataFormatHelpers.getEnvironmentPathName(envName), dataFormatHelpers.getControllerPathName(controllerVal));
                completionTimesNormal = analysis.getCompletionTimes(runDataPathPrefix, numRuns);
                runDataPathPrefix = "static_wsr2500_gpev2000/NR{}_FOR_{}_{}".format(nrVal, dataFormatHelpers.getEnvironmentPathName(envName), dataFormatHelpers.getControllerPathName(controllerVal));
                completionTimesNoize = analysis.getCompletionTimes(runDataPathPrefix, numRuns);



            #print(completionTimesNoize);
            if (DO_COMPLETION_TIME_AVERAGE_DIFF):
                results_completionTimeAverageDiff[c][env] = pyCreeper.crData.getAverageOfAList(completionTimesNoize) - pyCreeper.crData.getAverageOfAList(completionTimesNormal);
                #print("avg normal {} avg noize {}  diff {}".format(crData.getAverage(completionTimesNormal), crData.getAverage(completionTimesNoize),results_completionTimeAverageDiff[c][env]));

            if (DO_COMPLETION_TIME_MEDIAN_DIFF):
                results_completionTimeMedianDiff[c][env] = pyCreeper.crData.getMedianOfAList(completionTimesNoize) - pyCreeper.crData.getMedianOfAList(completionTimesNormal);
                #print("mean normal {} mean noize {}  diff {}".format(crData.getMedian(completionTimesNormal), crData.getMedian(completionTimesNoize),results_completionTimeAverageDiff[c][env]));
            if (DO_COMPLETION_TIME_VARIANCE_DIFF):
                results_completionTimeVarianceDiff[c][env] = numpy.std(completionTimesNoize) - numpy.std(completionTimesNormal);
                #print("mean normal {} mean noize {}  diff {}".format(crData.getMedian(completionTimesNormal), crData.getMedian(completionTimesNoize),results_completionTimeAverageDiff[c][env]));

            if (DO_CU_DIFF or DO_CU_VARIANCE_DIFF or DO_CM_DIFF or DO_CD_DIFF):
                runDataPathPrefix = "static_wsr2500/NR{}_FOR_{}_{}".format(nrVal, dataFormatHelpers.getEnvironmentPathName(envName), dataFormatHelpers.getControllerPathName(controllerVal));
                icrDataNormal = analysis.getICRData(runDataPathPrefix, numRuns, nrVal, dataFormatHelpers.getMaxTimeForExperiment("static_wsr2500"), 1.0)
                runDataPathPrefix = "static_wsr2500_gpev2000/NR{}_FOR_{}_{}".format(nrVal, dataFormatHelpers.getEnvironmentPathName(envName), dataFormatHelpers.getControllerPathName(controllerVal));
                icrDataNoize = analysis.getICRData(runDataPathPrefix, numRuns, nrVal, dataFormatHelpers.getMaxTimeForExperiment("static_wsr2500_gpev2000"), 1.0)


                results_cuAverageDiff[c][env] = pyCreeper.crData.getMedianOfAList(icrDataNoize[1])-pyCreeper.crData.getMedianOfAList(icrDataNormal[1]);
                results_cuVarianceDiff[c][env] = numpy.std(icrDataNoize[1])-numpy.std(icrDataNormal[1]);
                results_cdDiff[c][env] = pyCreeper.crData.getAverageOfAList(icrDataNoize[2])-pyCreeper.crData.getAverageOfAList(icrDataNormal[2]);
                results_cmDiff[c][env] = pyCreeper.crData.getAverageOfAList(icrDataNoize[4])-pyCreeper.crData.getAverageOfAList(icrDataNormal[4]);



            if (DO_UNEMPLOYMENT_RATE_DIFF or DO_UNEVEN_EMPLOYMENT_RATE_DIFF or DO_FORAGING_TRAVEL_TIME_DIFF):
                runDataPathPrefix = "static_wsr2500/NR{}_FOR_{}_{}".format(nrVal, dataFormatHelpers.getEnvironmentPathName(envName), dataFormatHelpers.getControllerPathName(controllerVal));
                icrSecondaryDataNormal = analysis.getICRSecondaryData(runDataPathPrefix, numRuns, nrVal, dataFormatHelpers.getMaxTimeForExperiment("static_wsr2500"))
                runDataPathPrefix = "static_wsr2500_gpev2000/NR{}_FOR_{}_{}".format(nrVal, dataFormatHelpers.getEnvironmentPathName(envName), dataFormatHelpers.getControllerPathName(controllerVal));
                icrSecondaryDataNoize = analysis.getICRSecondaryData(runDataPathPrefix, numRuns, nrVal, dataFormatHelpers.getMaxTimeForExperiment("static_wsr2500_gpev2000"))


                results_unemploymentRateDiff[c][env] = pyCreeper.crData.getMedianOfAList(icrSecondaryDataNoize[0]) - pyCreeper.crData.getMedianOfAList(icrSecondaryDataNormal[0]);
                results_unevenEmploymentRateDiff[c][env] = pyCreeper.crData.getMedianOfAList(icrSecondaryDataNoize[1]) - pyCreeper.crData.getMedianOfAList(icrSecondaryDataNormal[1]);
                results_foragingTravelTimeDiff[c][env] = pyCreeper.crData.getMedianOfAList(icrSecondaryDataNoize[2]) - pyCreeper.crData.getMedianOfAList(icrSecondaryDataNormal[2]);


    markers, lineStyles = visualisation.getPlotStylesForControllers(controllers,["static_wsr2500" for x in range(len(controllers))]);


    if (DO_COMPLETION_TIME_AVERAGE_DIFF):
        plotFilePath="{}/completionTimeAverageDiff_NR{}".format(constants.PLOTS_PATH,nrVal);
        if (constants.USING_SIMULATION_RESULTS):
            plotFilePath += "_sim";
        plotFilePath += ".png";
        yMin = 0;
        yMax = 15;
        #print(results_completionTimeAverageDiff);
        pyCreeper.crGraphs.createLinePlot(results_completionTimeAverageDiff, markers_=markers, doWilcoxon_=True, lineWidth_=2, xAxisGroupSize_=3, lineStyles_=lineStyles, yTicksStep_=2, yMin_=yMin,yMax_=yMax, yLabel_="$\Delta$ avg. completion time [mins]", xTickLabels_=envs, legendLabels_=controllers, filePath_=plotFilePath, size_=(15,5), gridType_=pyCreeper.crGraphs.GRID_TYPE.MAJOR, markerSize_=10);

    if (DO_COMPLETION_TIME_MEDIAN_DIFF):
        plotFilePath="{}/completionTimeMedianDiff_NR{}".format(constants.PLOTS_PATH,nrVal);
        if (constants.USING_SIMULATION_RESULTS):
            plotFilePath += "_sim";
        plotFilePath += ".png";
        yMin = 0;
        yMax = 15;
        #print(results_completionTimeMedianDiff);
        pyCreeper.crGraphs.createLinePlot(results_completionTimeMedianDiff, markers_=markers, doWilcoxon_=True, lineWidth_=2, xAxisGroupSize_=3, lineStyles_=lineStyles, yTicksStep_=2, yMin_=yMin,yMax_=yMax, yLabel_="$\Delta$ med. completion time [mins]", xTickLabels_=envs, legendLabels_=controllers, filePath_=plotFilePath, size_=(15,5), gridType_=pyCreeper.crGraphs.GRID_TYPE.MAJOR, markerSize_=10);

    if (DO_COMPLETION_TIME_VARIANCE_DIFF):
        plotFilePath="{}/completionTimeVarianceDiff_NR{}".format(constants.PLOTS_PATH,nrVal);
        if (constants.USING_SIMULATION_RESULTS):
            plotFilePath += "_sim";
        plotFilePath += ".png";
        yMin = 0;
        yMax = 6;
        #print(results_completionTimeMedianDiff);
        pyCreeper.crGraphs.createLinePlot(results_completionTimeVarianceDiff, markers_=markers, doWilcoxon_=True, lineWidth_=2, xAxisGroupSize_=3, lineStyles_=lineStyles, yTicksStep_=1, yMin_=yMin,yMax_=yMax, yLabel_="$\Delta$ completion time variance [mins]", xTickLabels_=envs, legendLabels_=controllers, filePath_=plotFilePath, size_=(15,5), gridType_=pyCreeper.crGraphs.GRID_TYPE.MAJOR, markerSize_=10);

    if (DO_CU_DIFF):
        plotFilePath="{}/cuDiff_NR{}".format(constants.PLOTS_PATH,nrVal);
        if (constants.USING_SIMULATION_RESULTS):
            plotFilePath += "_sim";
        plotFilePath += ".png";
        yMin = pyCreeper.crGraphs.INVALID_VALUE;
        yMax = pyCreeper.crGraphs.INVALID_VALUE;
        #print(results_completionTimeMedianDiff);
        pyCreeper.crGraphs.createLinePlot(results_cuAverageDiff, markers_=markers, doWilcoxon_=True, lineWidth_=2, xAxisGroupSize_=3, lineStyles_=lineStyles, yMin_=yMin,yMax_=yMax, yLabel_="$\Delta$ med. $C_U$", xTickLabels_=envs, legendLabels_=controllers, filePath_=plotFilePath, size_=(15,5), gridType_=pyCreeper.crGraphs.GRID_TYPE.MAJOR, markerSize_=10);

    if (DO_CU_VARIANCE_DIFF):
        plotFilePath="{}/cuVarianceDiff_NR{}".format(constants.PLOTS_PATH,nrVal);
        if (constants.USING_SIMULATION_RESULTS):
            plotFilePath += "_sim";
        plotFilePath += ".png";
        yMin = pyCreeper.crGraphs.INVALID_VALUE;
        yMax = pyCreeper.crGraphs.INVALID_VALUE;
        #print(results_completionTimeMedianDiff);
        pyCreeper.crGraphs.createLinePlot(results_cuVarianceDiff, markers_=markers, doWilcoxon_=True, lineWidth_=2, xAxisGroupSize_=3, lineStyles_=lineStyles, yMin_=yMin,yMax_=yMax, yLabel_="$\Delta$ avg. $C_U$ variance", xTickLabels_=envs, legendLabels_=controllers, filePath_=plotFilePath, size_=(15,5), gridType_=pyCreeper.crGraphs.GRID_TYPE.MAJOR, markerSize_=10);

    if (DO_CD_DIFF):
        plotFilePath="{}/cdDiff_NR{}".format(constants.PLOTS_PATH,nrVal);
        if (constants.USING_SIMULATION_RESULTS):
            plotFilePath += "_sim";
        plotFilePath += ".png";
        yMin = pyCreeper.crGraphs.INVALID_VALUE;
        yMax = pyCreeper.crGraphs.INVALID_VALUE;
        #print(results_completionTimeMedianDiff);
        pyCreeper.crGraphs.createLinePlot(results_cdDiff, markers_=markers, doWilcoxon_=True, lineWidth_=2, xAxisGroupSize_=3, lineStyles_=lineStyles, yMin_=yMin,yMax_=yMax, yLabel_="$\Delta$ avg. $C_D$", xTickLabels_=envs, legendLabels_=controllers, filePath_=plotFilePath, size_=(15,5), gridType_=pyCreeper.crGraphs.GRID_TYPE.MAJOR, markerSize_=10);

    if (DO_CM_DIFF):
        plotFilePath="{}/cmDiff_NR{}".format(constants.PLOTS_PATH,nrVal);
        if (constants.USING_SIMULATION_RESULTS):
            plotFilePath += "_sim";
        plotFilePath += ".png";
        yMin = pyCreeper.crGraphs.INVALID_VALUE;
        yMax = pyCreeper.crGraphs.INVALID_VALUE;
        #print(results_completionTimeMedianDiff);
        pyCreeper.crGraphs.createLinePlot(results_cmDiff, markers_=markers, doWilcoxon_=True, lineWidth_=2, xAxisGroupSize_=3, yTicksStep_=100, lineStyles_=lineStyles, yMin_=yMin,yMax_=yMax, yLabel_="$\Delta$ avg. $C_M$", xTickLabels_=envs, legendLabels_=controllers, filePath_=plotFilePath, size_=(15,5), gridType_=pyCreeper.crGraphs.GRID_TYPE.MAJOR, markerSize_=10);


    if (DO_UNEMPLOYMENT_RATE_DIFF):
        plotFilePath="{}/unemploymentRateDiff_NR{}".format(constants.PLOTS_PATH,nrVal);
        if (constants.USING_SIMULATION_RESULTS):
            plotFilePath += "_sim";
        plotFilePath += ".png";
        yMin = pyCreeper.crGraphs.INVALID_VALUE;
        yMax = pyCreeper.crGraphs.INVALID_VALUE;
        #print(results_completionTimeMedianDiff);
        pyCreeper.crGraphs.createLinePlot(results_unemploymentRateDiff, markers_=markers, doWilcoxon_=True, lineWidth_=2, xAxisGroupSize_=3, lineStyles_=lineStyles, yMin_=yMin,yMax_=yMax, yLabel_="$\Delta$ med. unemployment rate", xTickLabels_=envs, legendLabels_=controllers, filePath_=plotFilePath, size_=(15,5), gridType_=pyCreeper.crGraphs.GRID_TYPE.MAJOR, markerSize_=10);

    if (DO_UNEVEN_EMPLOYMENT_RATE_DIFF):
        plotFilePath="{}/unevenEmploymentRateDiff_NR{}".format(constants.PLOTS_PATH,nrVal);
        if (constants.USING_SIMULATION_RESULTS):
            plotFilePath += "_sim";
        plotFilePath += ".png";
        yMin = pyCreeper.crGraphs.INVALID_VALUE;
        yMax = pyCreeper.crGraphs.INVALID_VALUE;
        #print(results_completionTimeMedianDiff);
        pyCreeper.crGraphs.createLinePlot(results_unevenEmploymentRateDiff, markers_=markers, doWilcoxon_=True, lineWidth_=2, xAxisGroupSize_=3, yTicksStep_=0.1, lineStyles_=lineStyles, yMin_=yMin,yMax_=yMax, yLabel_="$\Delta$ med. uneven employment rate", xTickLabels_=envs, legendLabels_=controllers, filePath_=plotFilePath, size_=(15,5), gridType_=pyCreeper.crGraphs.GRID_TYPE.MAJOR, markerSize_=10);

    if (DO_FORAGING_TRAVEL_TIME_DIFF):
        plotFilePath="{}/foragingTravelTimeDiff_NR{}".format(constants.PLOTS_PATH,nrVal);
        if (constants.USING_SIMULATION_RESULTS):
            plotFilePath += "_sim";
        plotFilePath += ".png";
        yMin = pyCreeper.crGraphs.INVALID_VALUE;
        yMax = pyCreeper.crGraphs.INVALID_VALUE;
        #print(results_completionTimeMedianDiff);
        pyCreeper.crGraphs.createLinePlot(results_foragingTravelTimeDiff, markers_=markers, doWilcoxon_=True, lineWidth_=2, xAxisGroupSize_=3, lineStyles_=lineStyles, yMin_=yMin,yMax_=yMax, yTicksStep_=5, yLabel_="$\Delta$ med. foraging travel time", xTickLabels_=envs, legendLabels_=controllers, filePath_=plotFilePath, size_=(15,5), gridType_=pyCreeper.crGraphs.GRID_TYPE.MAJOR, markerSize_=10);
