import constants;


#============================ RELATED TO DATA  ======================

def getMaxTimeForExperiment(experimentName_, numOfRobots_=-1):
    if ("argos" in experimentName_.lower()):
        if (numOfRobots_ == 10):
            return 36000;
        elif (numOfRobots_ == 25):
            return 14400;
        else:
            return 10800;
    elif ("gpev2000" in experimentName_):
        return 40*60;
    else:
        return 15*60;

def getRewardGainRateForExperiment(experimentName_):
    if ("PERFORM" in experimentName_):
        return 1.0/400;
    return 1.0;

def getMaxRewardForExperiment(experimentName_):
    if ("argos" in experimentName_.lower()):
        return 100;
    else:
        return 48;

def getNumOfRobotsForExperiment(experimentName_):
    if ("argos" in experimentName_.lower() or "A_" in experimentName_):
        if ("NR10" in experimentName_):
            return 10;
        elif ("NR25" in experimentName_):
            return 25;
        elif ("NR50" in experimentName_):
            return 50;
    else:
        return 5;

#============================ RELATED TO FILE PATHS ======================

def getBaseDataPath():
    """
    :return: A base absolute path where data for a particular set of results is
    """
    if constants.USING_SIMULATION_RESULTS:
        return constants.DATA_PATH_FROM_SIMULATION
    elif constants.USING_FOOTBOTS_SIMULATION_RESULTS:
        return constants.DATA_PATH_FROM_FOOTBOT_SIMULATION
    else:
        return constants.DATA_PATH;


def getEventDescriptionForType(type_):
    if (constants.USING_SIMULATION_RESULTS):
        #-- translate to the event formatting in the simulation
        if (type_ == constants.E_REWARD_RECEIVED):
            return 'REWARD_FINISHED';
        elif (type_ == constants.E_SITE_ADDED):
            return 'E_TASK_ADDED';
        elif (type_ == constants.E_SITE_COMPLETED):
            return 'E_TASK_COMPLETED';
        elif (type_ == constants.E_SITE_DESTROYED):
            return 'E_TASK_DESTROYED';
        elif (type_ == constants.E_SITE_SCOUTED):
            return 'TASK_SCOUTED';
        elif (type_ == constants.E_SITE_REACHED):
            return 'TASK_REACHED';
        elif (type_ == constants.E_SITE_MISSING):
            return 'TASK_MISSING';
        elif (type_ == constants.E_SITE_PAUSED):
            return 'TASK_PAUSED';
        elif (type_ == constants.E_SITE_ABANDONED):
            return 'TASK_ABANDONED';
        elif (type_ == constants.E_ROBOT_RECRUITED):
            return 'ROBOT_RECRUITED';
        elif (type_ == constants.E_SITE_SWITCHED):
            return 'TASK_SWITCHED';
        elif (type_ == constants.E_SITE_STARTED):
            return 'TASK_STARTED';
        elif (type_ == constants.E_REWARD_STARTED):
            return 'REWARD_STARTED';
        elif (type_ == constants.E_REWARD_FINISHED):
            return 'REWARD_FINISHED';
        elif (type_ == constants.E_ROBOT_BROKE):
            return 'ROBOT_BROKE';
        elif (type_ == constants.E_ROBOT_FIXED):
            return 'ROBOT_FIXED';

        return type_;
    else:
        return type_;

def getEnvironmentPathName(envName_):
    """
    :param envName_: Standard name as appears on the graphs, e.g. Heap1
    :return: environment name as it appears in a data path, depends on experiment type
    """

    #-- convert to lower case
    envName = envName_.lower();

    #-- additional possibilities
    if (constants.USING_FOOTBOTS_SIMULATION_RESULTS):
        envName = envName.replace('heap','group');
        envName = envName.replace('scatter','rand');

    return envName;

def getControllerPathName(controllerName_):
    """
    :param controllerName_: Standard name as appears on the graphs, e.g. Solitary
    :return: controler name as it appears in a data path, depends on experiment type
    """

    #-- convert to lower case
    controllerName = controllerName_.lower();

    #-- additional possibilities
    if (constants.USING_FOOTBOTS_SIMULATION_RESULTS):
        controllerName = controllerName.replace('local broadcaster','localBroadcaster');
    else:
        controllerName = controllerName.replace('solitary','S');
        controllerName = controllerName.replace('local broadcaster','LB_commD12500');

    return controllerName;

