import numpy;

import pyCreeper;
import analysis;
import constants;
import visualisation;
from helpers import dataFormatHelpers;

pyCreeper.crGraphs.DEBUG_LEVEL = 0;

PLOTS_DIRECTORY = "img_cp01";
DO_COMPLETION_TIME = False;
DO_COMPLETION_TIME_NOISE_EFF = False;
DO_DISCUSSION_EPUCK_PLOTS = False;
DO_DISCUSSION_FOOTBOTS = True;

controllers = ['Solitary','Local broadcaster'];
controllerLabels = ['Solitary', 'Broadcaster'];
envs = ['Heap1-7000','Heap3-7000','Scatter12-7000','Heap1-14000','Heap3-14000','Scatter12-14000'];
envLabels = ['$N_W=1$','$N_W=3$','$N_W=12$', '$N_W=1$','$N_W=3$','$N_W=12$'];

envs_footbots = ['Heap1-8','Heap2-8','Heap4-8','Scatter25-8','Heap1-12','Heap2-12','Heap4-12','Scatter25-12'];
envLabels_footbots = ['$N_W=1$','$N_W=2$','$N_W=4$','$N_W=25$', '$N_W=1$','$N_W=2$','$N_W=4$','$N_W=25$'];
numRuns = 10;
nrVal = 5;


#============= get data ==============
results_completionTime_normal = [[[] for j in range(len(envs))] for k in range(len(controllers))];
results_completionTime_noise = [[[] for j in range(len(envs))] for k in range(len(controllers))];

results_completionTimeAverageDiff = [[[] for j in range(len(envs))] for k in range(len(controllers))];
results_completionTimeVarianceDiff = [[[] for j in range(len(envs))] for k in range(len(controllers))];

results_icrSecondary_normal = [[[] for j in range(len(envs))] for k in range(len(controllers))];
results_icrSecondary_noise = [[[] for j in range(len(envs))] for k in range(len(controllers))];

results_completionTime_footbots = [[[] for j in range(len(envs_footbots))] for k in range(len(controllers))];

if (DO_COMPLETION_TIME or DO_COMPLETION_TIME_NOISE_EFF or DO_DISCUSSION_EPUCK_PLOTS):
    for c in range(len(controllers)):
        controllerVal = controllers[c];
        for env in range(len(envs)):
            envName = envs[env];

            #-- normal
            dataPathPrefix = "static_wsr2500/NR{}_FOR_{}_{}".format(nrVal, dataFormatHelpers.getEnvironmentPathName(envName), dataFormatHelpers.getControllerPathName(controllerVal));
            if (DO_COMPLETION_TIME or DO_COMPLETION_TIME_NOISE_EFF):
                results_completionTime_normal[c][env] = analysis.getCompletionTimes(dataPathPrefix, numRuns);
            if (DO_DISCUSSION_EPUCK_PLOTS):
                results_icrSecondary_normal[c][env] = analysis.getICRSecondaryData(dataPathPrefix, numRuns, nrVal, dataFormatHelpers.getMaxTimeForExperiment("static_wsr2500"));

            #-- noise
            dataPathPrefix = "static_wsr2500_gpev2000/NR{}_FOR_{}_{}".format(nrVal, dataFormatHelpers.getEnvironmentPathName(envName), dataFormatHelpers.getControllerPathName(controllerVal));
            if (DO_COMPLETION_TIME or DO_COMPLETION_TIME_NOISE_EFF):
                results_completionTime_noise[c][env] = analysis.getCompletionTimes(dataPathPrefix, numRuns);
            if (DO_DISCUSSION_EPUCK_PLOTS):
                results_icrSecondary_noise[c][env] = analysis.getICRSecondaryData(dataPathPrefix, numRuns, nrVal, dataFormatHelpers.getMaxTimeForExperiment("static_wsr2500"));

            #-- calculations
            if (DO_COMPLETION_TIME_NOISE_EFF):
                results_completionTimeAverageDiff[c][env] = pyCreeper.crData.getAverageOfAList(results_completionTime_noise[c][env]) - pyCreeper.crData.getAverageOfAList(results_completionTime_normal[c][env]);
                results_completionTimeVarianceDiff[c][env] = numpy.std(results_completionTime_noise[c][env]) - numpy.std(results_completionTime_normal[c][env]);

if (DO_DISCUSSION_FOOTBOTS):
    constants.USING_FOOTBOTS_SIMULATION_RESULTS = True;
    numRuns = 50;
    nrVal = 10;
    for c in range(len(controllers)):
        controllerVal = controllers[c];
        for env in range(len(envs_footbots)):
            envName = envs_footbots[env];
            dataPathPrefix = "A_{}/COLLECT_RT1-1_{}_{}_NR{}".format(dataFormatHelpers.getControllerPathName(controllerVal), dataFormatHelpers.getEnvironmentPathName(envName), dataFormatHelpers.getControllerPathName(controllerVal), nrVal);
            results_completionTime_footbots[c][env] = analysis.getCompletionTimes(dataPathPrefix, numRuns, convertToHours_=True);


#============= plotting ==============

markers, lineStyles = visualisation.getPlotStylesForControllers(controllers,["static_wsr2500" for x in range(len(controllers))]);

style = pyCreeper.crGraphStyle.crGraphStyle();
style.lineStyles = lineStyles;
style.markers = markers;

style.figureSize = (15,5);
style.markerSize = 15;
style.lineWidth = 3;

style.labelFontSize = 31;
style.legendFontSize = 27;
style.tickFontSize = 23;
style.xOffset = 0.04;

pyCreeper.crGraphs.setStyle(style);

if (DO_COMPLETION_TIME):
    style.legendPosition = pyCreeper.crGraphStyle.LEGEND_POSITION.LOWER_RIGHT;

    experimentNames = ['static_wsr2500','static_wsr2500_gpev2000'];
    for p in range(len(experimentNames)):
        experimentNamePrefix = experimentNames[p];
        plotFilePath="{}/{}/completionTime_{}.png".format(constants.PLOTS_PATH,PLOTS_DIRECTORY,experimentNamePrefix);
        data = results_completionTime_normal; yMin = 4; yMax = 16; yTickStep = 2;
        if ('gpev2000' in experimentNamePrefix):
            data = results_completionTime_noise; yMin = 4; yMax = 28; yTickStep = 4;
        pyCreeper.crGraphs.createLinePlot(data, doWilcoxon_=False, xAxisGroupSize_=3, yLabel_="Completion time \n [mins]", yTicksStep_=yTickStep, yMin_=yMin,yMax_=yMax,  xTickLabels_=envLabels, legendLabels_=controllerLabels, showBoxPlots_=True, filePath_=plotFilePath);

if (DO_COMPLETION_TIME_NOISE_EFF):
    style.legendPosition = pyCreeper.crGraphStyle.LEGEND_POSITION.UPPER_LEFT;
    style.yOffset = 0.012;
    plotFilePath="{}/{}/completionTimeAverageDiff.png".format(constants.PLOTS_PATH,PLOTS_DIRECTORY);
    yMin = 0;
    yMax = 15;
    yTickStep = 2;
    pyCreeper.crGraphs.createLinePlot(results_completionTimeAverageDiff, xAxisGroupSize_=3, yLabel_="$\Delta$ Average completion \n time [mins]", useBoxPlotPadding_=True, yTicksStep_=yTickStep, yMin_=yMin,yMax_=yMax,  xTickLabels_=envLabels, legendLabels_=controllerLabels, filePath_=plotFilePath);

    style.yOffset = 0;
    plotFilePath="{}/{}/completionTimeVarianceDiff.png".format(constants.PLOTS_PATH,PLOTS_DIRECTORY);
    yMin = 0;
    yMax = 6;
    yTickStep = 1;
    pyCreeper.crGraphs.createLinePlot(results_completionTimeVarianceDiff, xAxisGroupSize_=3, yLabel_="$\Delta$ Completion time \n variance [mins]", useBoxPlotPadding_=True,  yTicksStep_=yTickStep, yMin_=yMin,yMax_=yMax,  xTickLabels_=envLabels, legendLabels_=controllerLabels, filePath_=plotFilePath);

if (DO_DISCUSSION_EPUCK_PLOTS):
    plotFilePath="{}/{}/*GRAPH_TYPE*.png".format(constants.PLOTS_PATH,PLOTS_DIRECTORY);
    visualisation.visualiseICRSecondaryData(results_icrSecondary_normal,plotFilePath,controllerLabels,envLabels, False, style);

    plotFilePath="{}/{}/*GRAPH_TYPE*_noise.png".format(constants.PLOTS_PATH,PLOTS_DIRECTORY);
    visualisation.visualiseICRSecondaryData(results_icrSecondary_noise,plotFilePath,controllerLabels,envLabels, False, style);

if (DO_DISCUSSION_FOOTBOTS):
    style.legendPosition = pyCreeper.crGraphStyle.LEGEND_POSITION.LOWER_RIGHT;
    plotFilePath="{}/{}/completionTime_footbots.png".format(constants.PLOTS_PATH,PLOTS_DIRECTORY);
    yMin = 0;
    yMax = 5;
    pyCreeper.crGraphs.createLinePlot(results_completionTime_footbots, doWilcoxon_=False, xAxisGroupSize_=4, yMin_=yMin,yMax_=yMax, yLabel_="Completion time \n [hours]", xTickLabels_=envLabels_footbots, legendLabels_=controllerLabels, showBoxPlots_=True, filePath_=plotFilePath);
