#####
## Takes all robot report data (labelled report0-N) and adds in into a speific file
#####

pushd `dirname $0` > /dev/null
MY_DIR=`pwd`
popd > /dev/null
source $MY_DIR/_inc_constants.sh

filePath=$1
logFilePrefix=$2
robotId=$3

REMOTE_FILE_DIRECTORY="/root/code_lenka/log"

if [ "${logFilePrefix}" == "" ] || [ "${robotId}" == "" ] || [ "${filePath}" == "" ]; then
	echo "!!! Please specify target file, log file prefix and robot id, e.g. ./addRobotDataToFile.sh /Users/me/data.txt myExperiment 38"
	exit
fi


if [ -f ${filePath} ]; then
	echo ">>> File ${filePath} already exists"
else
	touch ${filePath}
	echo ">>> Created ${filePath}"
fi

fileNo=0
fileFound=1
while [ $fileFound -eq 1 ]; do
	remoteFilePath="${REMOTE_FILE_DIRECTORY}/${logFilePrefix}_infoEvents${fileNo}.txt"
	if ssh root@192.168.20.${robotId} stat ${remoteFilePath} \> /dev/null 2\>\&1
	then
		echo "   ... Copying data from robot ${robotId}:${remoteFilePath}"
		ssh root@192.168.20.${robotId} "cat ${remoteFilePath}" >> ${filePath}
		((fileNo++))
	else
		fileFound=0
	fi
				
done

echo ">>> Done copying data for robot ${robotId}"
