pushd `dirname $0` > /dev/null
MY_DIR=`pwd`
popd > /dev/null
source $MY_DIR/../scripts/_inc_constants.sh


function doCmake() {
	if [ -d build ]; then
		rm -rf build
	fi
	mkdir build
	cd build
	cmake ..
	cd ../
}

function compile() {
    echo ">>>>>> Compiling..."
	cd build
    make
	cd ../
	
	# copy settings file
	cp ../experiments/runSettings_dev.txt launch/runSettings.txt
}


function run() {
	# remove latest logs
#rm -rf ~/.ros/log/latest
	
	# kill all potentially running processes
	pkill Epuck
	
	# copy settings file
	cp ../experiments/runSettings_dev.txt launch/runSettings.txt
	
	#run
	cd launch
	roslaunch cpp_observer test.launch
		
}

COMPILE=0
RUN=0
CMAKE=0

while getopts "crmo:" opt; do
case "$opt" in

c)
    COMPILE=1;;
r)
    RUN=1;;
m)
    CMAKE=1;;

esac
done

shift $((OPTIND-1))

[ "$1" = "--" ] && shift


if [ $CMAKE -eq 1 ]; then
	doCmake
fi

if [ $COMPILE -eq 1 ]; then
    compile
fi

if [ $RUN -eq 1 ]; then
    run
fi




