#include <stdlib.h>
#include <IPCInterface.h>
#include <cpp_observer/ViconPosition.h>
#include "ros/ros.h"
#include "vector"
#include "string"
#include "sstream"
#include "EpuckCommSubscriberTopic.h"

void EpuckCommSubscriberTopic::UpdatePositionCallback(const cpp_observer::ViconPosition::ConstPtr& msg){
	worksiteX = msg->worksite1X.data;
	worksiteY = msg->worksite1Y.data;
	worksiteId = msg->worksite1Id.data;
	recruiterId = msg->resourceReceived.data;

	//std::cout << " UpdatePositionCallback: rid=" << recruiterId << std::endl;
}

int EpuckCommSubscriberTopic::GetWorksiteX(){
  return worksiteX;
}

int EpuckCommSubscriberTopic::GetWorksiteY(){
  return worksiteY;
}

int EpuckCommSubscriberTopic::GetWorksiteId(){
  return worksiteId;
}

int EpuckCommSubscriberTopic::GetRecruiterId(){
  return recruiterId;
}




void EpuckCommSubscriberTopic::SetTopicName(std::string SubscriberTopicName){
  this->SubscriberTopicName = SubscriberTopicName;
}

std::string* EpuckCommSubscriberTopic::GetTopicName(){
  return &SubscriberTopicName;
}

void EpuckCommSubscriberTopic::SetIP(std::string IP){
  this->IP = IP;
}

std::string* EpuckCommSubscriberTopic::GetIP(){
  return &IP;
}
