pushd `dirname $0` > /dev/null
MY_DIR=`pwd`
popd > /dev/null
source $MY_DIR/../scripts/_inc_constants.sh

WORKING_DIR_PATH="code_lenka/"
FOLDER_NAME="taskDiscovery"

function doCmake() {
	if [ -d build ]; then
		rm -rf build
	fi
	mkdir build
	cd build
	cmake ..
	cd ../
}

function compile() {
    echo ">>>>>> Compiling..."
	cd build
    make
	cd ../
}


function deploy() {
	#-- move extra files
	for robotId in ${ROBOT_IDS[@]}; do
		sed -e "s^\[THIS_ROBOT_ID\]^${robotId}^g;\
				" \
				../experiments/runSettings_dev.txt > ../_temp/runSettings_robot${robotId}.txt
	done
	
	#-- start copying to robots
	if [ $DEPLOY_SETTINGS_ONLY -eq 1 ]; then
		for robotId in ${ROBOT_IDS[@]}; do
			ssh root@192.168.20.${robotId} "rm ${WORKING_DIR_PATH}${FOLDER_NAME}/bin/runSettings.txt;"
		done
	else
		for robotId in ${ROBOT_IDS[@]}; do
			echo ">>>>>> Deploying code to robot ${robotId}"
			ssh root@192.168.20.${robotId} "cd ${WORKING_DIR_PATH}; rm -rf ${FOLDER_NAME};"
		done
		
		for robotId in ${ROBOT_IDS[@]}; do
			rsync -rlv --progress --delete build/ root@192.168.20.${robotId}:${WORKING_DIR_PATH}${FOLDER_NAME} < /dev/null &
		done
	fi
    
	#-- check if code is there
	keepChecking=1
	allRobotsHaveCode=0
	if [ $DEPLOY_SETTINGS_ONLY -eq 1 ]; then
		keepChecking=0
	fi
	while [ $keepChecking -eq 1 ]
	do
		allRobotsHaveCode=1
		for robotId in ${ROBOT_IDS[@]}; do
			if ssh root@192.168.20.${robotId} stat ${WORKING_DIR_PATH}${FOLDER_NAME}/bin/Controller \> /dev/null 2\>\&1
			then
				echo "   ... Robot ${robotId} code done"
			else
				echo "   ... Robot ${robotId} waiting"
				allRobotsHaveCode=0
			fi
		done
		
		if [ $allRobotsHaveCode -eq 1 ]; then
			keepChecking=0
		fi
	done
	
	#-- copy settings to robots
	for robotId in ${ROBOT_IDS[@]}; do
		echo ">>>>>> Deploying new settings to robot ${robotId}"
		rsync -lv --progress ../_temp/runSettings_robot${robotId}.txt root@192.168.20.${robotId}:${WORKING_DIR_PATH}${FOLDER_NAME}/bin/runSettings.txt < /dev/null &
	done
	
	#-- check if settings are there
	keepChecking=1
	allRobotsHaveCode=0
	while [ $keepChecking -eq 1 ]
	do
		allRobotsHaveCode=1
		for robotId in ${ROBOT_IDS[@]}; do
			if ssh root@192.168.20.${robotId} stat ${WORKING_DIR_PATH}${FOLDER_NAME}/bin/runSettings.txt \> /dev/null 2\>\&1
			then
				echo "   ... Robot ${robotId} done"
			else
				echo "   ... Robot ${robotId} waiting"
				allRobotsHaveCode=0
			fi
		done
		
		if [ $allRobotsHaveCode -eq 1 ]; then
			keepChecking=0
		fi
	done
	
	
	
}

function run() {
	for robotId in ${ROBOT_IDS[@]}; do
		echo ">>>>>> RUNNING ON ROBOT ${robotId}"
		ssh root@192.168.20.${robotId} "cd ${WORKING_DIR_PATH}/${FOLDER_NAME}/bin; ./Controller" &
	done
		
}

COMPILE=0
DEPLOY=0
DEPLOY_SETTINGS_ONLY=0
RUN=0
CMAKE=0

while getopts "cdsrmo:" opt; do
case "$opt" in

c)
    COMPILE=1;;
d)
    DEPLOY=1;;
s)
	DEPLOY=1;
	DEPLOY_SETTINGS_ONLY=1;;
r)
    RUN=1;;
m)
    CMAKE=1;;

esac
done

shift $((OPTIND-1))

[ "$1" = "--" ] && shift


if [ $CMAKE -eq 1 ]; then
	doCmake
fi

if [ $COMPILE -eq 1 ]; then
    compile
fi

if [ $DEPLOY -eq 1 ]; then
	deploy
fi

if [ $RUN -eq 1 ]; then
	run
fi





