/*
 * BeeActionController.h
 *
 *  Created on: 5 Jun 2017
 *      Author: lenka
 */

#ifndef SRC_EPUCK_ACTIONCONTROL_BEEACTIONCONTROLLER_H_
#define SRC_EPUCK_ACTIONCONTROL_BEEACTIONCONTROLLER_H_

#include <BaseActionController.h>

class BeeActionController : public BaseActionController {
public:
	BeeActionController(Robot* robot_, PathPlanner* pathPlanner_, EPuckBoardController* epuckBoardController_);
	virtual ~BeeActionController();


	BaseActionController::STATE ProcessCurrentState(uint64_t timeStamp_);

	void OnWorksiteScouted(int worksiteId_);
	void Scout();
	void SetState(STATE state_);

	void Observe();
	void OnUnloadResourceDone();
	void MoveInWaggleDance();
	void OnWorksiteProcessingDone();

private:
	int timeRecruitingLeft;
	int timeScoutingLeft;
};

#endif /* SRC_EPUCK_ACTIONCONTROL_BEEACTIONCONTROLLER_H_ */
