/*
 * Vector2D.cpp
 *
 *  Created on: 3 Apr 2017
 *      Author: lenka
 */

#include <math.h>
#include <sstream>

#include <constants.h>
#include "Vector2D.h"

Vector2D::Vector2D() {
	x=0;
	y=0;
}

Vector2D::Vector2D(double x_, double y_) {
	x=x_;
	y=y_;
}

Vector2D::~Vector2D() {
	// TODO Auto-generated destructor stub
}


void Vector2D::Normalize() {
	double m = sqrt((x* x + (y*y)));
	x /= m;
	y /=m;
}

std::string Vector2D::GetOutputString() {
	return GetOutputString(false);
}

std::string Vector2D::GetOutputString(bool isXAngleInDeg_) {
	std::ostringstream s;
	if (isXAngleInDeg_) {
		s << "[" << (x * 180/PI) << " deg;" << y << "]";
	} else {
		s << "[" << x << ";" << y << "]";
	}
	return  s.str();

}


bool Vector2D::GetIsTheSameAs(Vector2D* otherVec_) {
	return (this->x == otherVec_->x && this->y == otherVec_->y);
}

