#ifndef EPUCK_H
#define EPUCH_H


#include <stdint.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <iostream>

#include "actionControl/BaseActionController.h"


class Camera;
class EPuckBoardController;
class IPCInterface;
class PathPlanner;
class LinuxBoardController;
class Vector2D;

class Robot {

public:

	//-- params
	int controllerType;
	bool isDoingForaging;
	int worksiteRadius;
	int maxWorksiteD;
	int baseRadius;
	double taskAllocationLoadAmount;
	double foragingLoadAmount;
	Vector2D* basePosition;
	int reportSendTrials;
	int thisRobotId;
	int commTime;
	int lbNearWorksiteD;
	int bRecruitmentTime;
	double bScoutingProb;
	int bMaxScoutingTime;
	std::string logFilePrefix;

	int timeBetweenGlobalPositionUpdates;
	int globalPositionErrorVariance;
	int globalRotationErrorVariance;


	IPCInterface* ipcVicon;
	IPCInterface* ipcToVicon;
	IPCInterface* ipcComm;
	IPCInterface* ipcToComm;

	//--
	Robot(const char * n = NULL);
	~Robot();

	bool Update(uint64_t timeStamp_);
	bool Init();
	bool Reset();
	Camera* GetCameraDevice();
	EPuckBoardController* GetSPICommInterface();

	//-- actions
	void DoObstacleAvoidance();
  	void StopProgram();

  	//-- debuging
  	void PrintMicValues();
  	void PrintAccelerometersValues();
  	void PrintBatteryLevel();
  	void PrintStatus();

private:

	std::string Name;

	//-- navigation
	double avoid_weightleft[8];
	double avoid_weightright[8];
	int leftWheelVelocity;
	int rightWheelVelocity;

	//-- timing
	uint32_t timestamp;

	//-- camera
	Camera *camera;

	//-- other
	EPuckBoardController *epuckBoardController;

  
	PathPlanner* pathPlanner;
	LinuxBoardController* linuxBoardController;
	BaseActionController* actionController;

	void SetLEDSForState(BaseActionController::STATE state_, bool isCommunicating_, uint64_t timeStamp_);
};

#endif
