#ifndef IPCINTERFACE_H
#define IPCINTERFACE_H

#define DEBUG_MESSAGE_RECEIVED 0
#define DEBUG_POSITION_NOIZE 0
#define DEBUG_COMM_SENDING 0
#define DEBUG_COMM_RECEIVING 0

#include <string>
#include <ipc.hh>

#include <BaseActionController.h>


extern int userQuit;

class ELolMessage;
class EPuckBoardController;
class Camera;
class Robot;
class BaseActionController;


class IPCInterface {

 private :
  
	int hostPortNo;
	std::string hostIpAddress;

	IPC::IPC ipc;

	Robot *robot;
	EPuckBoardController *epuckBoardController;

	int viconData[10];
	int noiselessViconData[10];
	int prevViconData[10];
	int robotCommData[4];

	int timeTillNextPositionUpdate;



 public :
	static void ProcessParameterFile(Robot* robot_);

	IPCInterface(std::string hostIpAddress_, int hostPortNo_, Robot* robot_, EPuckBoardController* epuckBoardController_);
	~IPCInterface();

	void Init();
	void InitAsServer();

	void Update(uint64_t timeStamp_);

	void SendResourceRequest(int worksiteId_, double amount_);
	void SendInfoEventReport(InfoEventReport report_);
	void SendRecruitmentSignal(int worksiteId_, int worksiteX_, int worksiteY_);

	static void ReceiveCallback(const ELolMessage*msg, void *conn, void *ptr);


	int GetRobotPositionX();
	int GetRobotPositionY();
	double GetRobotPositionA();

	int GetWorksite1Id();
	int GetWorksite1X();
	int GetWorksite1Y();

	double GetResouceReturned();
	int GetResourcePorionId();
	double GetResourceLeft();

	int GetGlobalTime();

	int GetNoiselessRobotPositionX();
	int GetNoiselessRobotPositionY();

	int GetNoiselessWorksite1X();
	int GetNoiselessWorksite1Y();

	int GetRecruitedWorksiteId();
	int GetRecruitedWorksiteX();
	int GetRecruitedWorksiteY();
	int GetRecruiterId();


};
#endif






