import numpy;

import pyCreeper;
import analysis;
import constants;
import visualisation;
from helpers import dataFormatHelpers;
import icrfAnalyser;
icrfAnalyser.EVENTS_RECORD_HAS_ZERO_BASED_SITE_NUMBERING = False;

pyCreeper.crGraphs.DEBUG_LEVEL = 0;

PLOTS_DIRECTORY = "img_cp02";
DO_COMPLETION_TIME = True;
DO_ICR_ANALYSIS = True;
DO_ICR_ANALYSIS_OVER_TIME = False;


controllers = ['Solitary','Local broadcaster'];
controllerLabels = ['Solitary', 'Broadcaster'];
envs = ['Heap1-7000','Heap3-7000','Scatter12-7000','Heap1-14000','Heap3-14000','Scatter12-14000'];
envLabels = ['$N_W=1$','$N_W=3$','$N_W=12$', '$N_W=1$','$N_W=3$','$N_W=12$'];

envs_overTime = ['Heap3-7000'];
numRuns_overTime = 1;

experimentNames = ['static_wsr2500','static_wsr2500_gpev2000'];

numRuns = 10;
nrVal = 5;


#============= get data ==============
results_completionTime_normal = [[[] for j in range(len(envs))] for k in range(len(controllers))];
results_completionTime_noise = [[[] for j in range(len(envs))] for k in range(len(controllers))];

results_icr_normal = [[[] for j in range(len(envs))] for k in range(len(controllers))];
results_icr_noise = [[[] for j in range(len(envs))] for k in range(len(controllers))];

results_icrDataOverTime_normal = [[[] for j in range(len(envs_overTime))] for k in range(len(controllers))];
results_icrDataOverTime_noise = [[[] for j in range(len(envs_overTime))] for k in range(len(controllers))];

for c in range(len(controllers)):
    controllerVal = controllers[c];
    for env in range(len(envs)):
        envName = envs[env];

        #-- normal
        dataPathPrefix = "static_wsr2500/NR{}_FOR_{}_{}".format(nrVal, dataFormatHelpers.getEnvironmentPathName(envName), dataFormatHelpers.getControllerPathName(controllerVal));
        if (DO_COMPLETION_TIME):
            results_completionTime_normal[c][env] = analysis.getCompletionTimes(dataPathPrefix, numRuns);
        if (DO_ICR_ANALYSIS):
            results_icr_normal[c][env] = analysis.getICRData(dataPathPrefix, numRuns, nrVal, dataFormatHelpers.getMaxTimeForExperiment(dataPathPrefix),1.0);

        #-- noise
        dataPathPrefix = "static_wsr2500_gpev2000/NR{}_FOR_{}_{}".format(nrVal, dataFormatHelpers.getEnvironmentPathName(envName), dataFormatHelpers.getControllerPathName(controllerVal));
        if (DO_COMPLETION_TIME):
            results_completionTime_noise[c][env] = analysis.getCompletionTimes(dataPathPrefix, numRuns);
        if (DO_ICR_ANALYSIS):
            results_icr_noise[c][env] = analysis.getICRData(dataPathPrefix, numRuns, nrVal, dataFormatHelpers.getMaxTimeForExperiment(dataPathPrefix),1.0);


for c in range(len(controllers)):
    controllerVal = controllers[c];
    for env in range(len(envs_overTime)):
        envName = envs_overTime[env];

        #-- normal
        dataPathPrefix = "static_wsr2500/NR{}_FOR_{}_{}".format(nrVal, dataFormatHelpers.getEnvironmentPathName(envName), dataFormatHelpers.getControllerPathName(controllerVal));
        if (DO_ICR_ANALYSIS_OVER_TIME):
            results_icrDataOverTime_normal[c][env] = analysis.getICRDataOverTime(dataPathPrefix, numRuns_overTime, nrVal, dataFormatHelpers.getMaxTimeForExperiment(dataPathPrefix), dataFormatHelpers.getRewardGainRateForExperiment(dataPathPrefix));

        #-- noise
        dataPathPrefix = "static_wsr2500_gpev2000/NR{}_FOR_{}_{}".format(nrVal, dataFormatHelpers.getEnvironmentPathName(envName), dataFormatHelpers.getControllerPathName(controllerVal));
        if (DO_ICR_ANALYSIS_OVER_TIME):
            results_icrDataOverTime_noise[c][env] = analysis.getICRDataOverTime(dataPathPrefix, numRuns_overTime, nrVal, dataFormatHelpers.getMaxTimeForExperiment(dataPathPrefix), dataFormatHelpers.getRewardGainRateForExperiment(dataPathPrefix));


#============= plotting ==============

markers, lineStyles = visualisation.getPlotStylesForControllers(controllers,["static_wsr2500" for x in range(len(controllers))]);

style = pyCreeper.crGraphStyle.crGraphStyle();
style.colors = ['b','#ff3300'];
style.markers = ['o','d'];

style.figureSize = (10,5);
style.markerSize = 15;
style.lineWidth = 4;

style.labelFontSize = 31;
style.legendFontSize = 27;
style.tickFontSize = 23;
style.xOffset = 0.00;

pyCreeper.crGraphs.setStyle(style);


if (DO_COMPLETION_TIME):
    style.legendPosition = pyCreeper.crGraphStyle.LEGEND_POSITION.LOWER_RIGHT;
    for p in range(len(experimentNames)):
        experimentNamePrefix = experimentNames[p];
        plotFilePath="{}/{}/completionTime_{}.png".format(constants.PLOTS_PATH,PLOTS_DIRECTORY,experimentNamePrefix);
        data = results_completionTime_normal; yMin = 4; yMax = 16; yTickStep = 2;
        if ('gpev2000' in experimentNamePrefix):
            data = results_completionTime_noise; yMin = 4; yMax = 28; yTickStep = 4;
        pyCreeper.crGraphs.createLinePlot(data, doWilcoxon_=True, xAxisGroupSize_=3, yLabel_="Completion time \n [minutes]", yTicksStep_=yTickStep, yMin_=yMin,yMax_=yMax,  xTickLabels_=envLabels, legendLabels_=controllerLabels, showBoxPlots_=True, filePath_=plotFilePath);

if (DO_ICR_ANALYSIS):
    style.legendPosition = pyCreeper.crGraphStyle.LEGEND_POSITION.BEST;
    for p in range(len(experimentNames)):
        experimentNamePrefix = experimentNames[p];
        plotFilePath="{}/{}/*GRAPH_TYPE*_{}.png".format(constants.PLOTS_PATH,PLOTS_DIRECTORY,experimentNamePrefix);
        data = results_icr_normal;
        if ('gpev2000' in experimentNamePrefix):
            data = results_icr_noise;
        visualisation.visualiseICRData(data,plotFilePath,controllerLabels,envLabels, style, constants.PLOT_TYPE_CP02);

if (DO_ICR_ANALYSIS_OVER_TIME):

    styleOverTime = pyCreeper.crGraphStyle.crGraphStyle();
    styleOverTime.gridType = pyCreeper.crGraphStyle.GRID_TYPE.MAJOR;
    styleOverTime.lineWidth = 4;
    styleOverTime.numOfLegendColumns=1;
    styleOverTime.markerSize = 7;
    styleOverTime.figureSize = (11,5.3);
    styleOverTime.lineStyles = ['-','-','--','-.'];
    styleOverTime.markers = ['bs','r,','g,','m,'];
    styleOverTime.yOffset = -0.05;
    styleOverTime.xOffset = 0.005;
    styleOverTime.labelFontSize = 33;
    styleOverTime.legendFontSize = 29;
    styleOverTime.tickFontSize = 25;


    for p in range(len(experimentNames)):
        experimentNamePrefix = experimentNames[p];
        for c in range(len(controllers)):
            controllerVal = controllers[c];
            for env in range(len(envs_overTime)):
                envName = envs_overTime[env];
                plotFilePath="{}/{}/overTime_{}_*GRAPH_TYPE*_{}runs_{}_{}.png".format(constants.PLOTS_PATH,PLOTS_DIRECTORY,experimentNamePrefix,numRuns_overTime,envName,dataFormatHelpers.getControllerPathName(controllerVal));
                data = results_icrDataOverTime_normal;
                if ('gpev2000' in experimentNamePrefix):
                    data = results_icrDataOverTime_noise;
                visualisation.visualiseICRDataOverTime(data[c][env],plotFilePath,15*60,pyCreeperStyle_=styleOverTime);
