#!/bin/bash
pushd `dirname $0` > /dev/null
MY_DIR=`pwd`
popd > /dev/null
source $MY_DIR/_inc_constants.sh

robotId=$1
if [ "${robotId}" == "" ]; then
	echo ">>> Clearng logs of ALL ROBOTS"
else
	echo ">>> Clearng logs of robot ${robotId}"
fi


function clearLog() {
	if [ "${robotId}" == "" ]; then
		for robotId in ${ROBOT_IDS[@]}; do
		    echo ">>> Clearing logs on robot ${robotId}"
			ssh root@192.168.20.${robotId} "rm ~/code_lenka/log/*.txt"
		done
		
	else
		echo ">>> Clearing logs on robot ${robotId}"
		ssh root@192.168.20.${robotId} "rm ~/code_lenka/log/*.txt"	
	fi
}




keepAsking=1
while [ $keepAsking -eq 1 ]; do
	read -p "Do you wish to continue? (answer y for yes) " yn
	case $yn in
		[Yy]* ) clearLog; break;;
		* ) echo "You have selected no"; keepAsking=0;;
	esac
done
	
	
