% 20171004 Dan Heath
% Masters students skeletal script to generate code readable by our Labview
% system to change DMD image, power, pulse number, position
%
%

%%% size of image appropriate for the DLP3000 DMD
imageSizeY = 700;
dmd = 'pico';
imageSizeX = 900;

%%% some variables used for labelling our generated code/images
experimentNum = 1;
% theDate = datestr(date,'yyyymmdd');
theDate = '20171018';

%%% how to record the current path in Matlab, this is where we'll be saving
%%% code
path = pwd;

%%% only used for labelling purposes
identText = [theDate,'_',num2str(experimentNum)];%fed to addFastCodeTrimV4 to help label files
jumpStep = 500;

%%% this is where we'll be storing any images generated in this script
path2 = [path,'\images ',theDate,'_',num2str(experimentNum),'\'];

%%% set size of x and y jumps between machining positions, in mm
xStep = 100e-3;% 30m in real units
yStep = 100e-3;

%%% set how fast the translation stages will move
speed = 1;

%%% set a time in ms for Labview to wait after certain mechanical motions
stabiliseWait = 800;
stabiliseShortWait = 200;

%%% for now we'll generate a range of square shapes on the DMD
z = 1;
maxCircleSize = 200;
c = maxCircleSize;
minCircleSize = 40;
circleSizeInc = 10;
centreY = 350;
centreX = 450;
dmdImages = {};%create an empty cell array to keep track of all the file names of our images
[columnsInImage,rowsInImage] = meshgrid(1:imageSizeX, 1:imageSizeY);
while (c >=  minCircleSize)
    currImage = (rowsInImage - centreY).^2 + (columnsInImage - centreX).^2 <= c.^2;
    imName = ['circle',num2str(c),'.bmp'];%generate the name of the image, remember the file type on the end
    imagePath = [path2,imName];%full file path to the image, as you'd type into file explorer
    imagePath2 = strrep(imagePath,'\','\\');%We'll use a function later called sprintf on some string variables, which needs special treatment for some characters, such as backslashes
    %     imwrite(logical(currImage),imagePath);%save the image
    dmdImages{end+1} = imagePath2;%add the current image path to dmdImages
    z = z + 0.1;
    c = c - round(z^3);
end

%%% set how many different powers we're going to test our images at
% inputPowers = [50:100:450];
inputPowers = [450];

%%% set how many pulses to fire (this can be varied at every position, but
%%% for now we'll just use one pulse everywhere
numPulses = 1;

%we'll save our code in a special Matlab class called a 'structure'
output = struct;

%%% start generating code
for jy = 1:length(inputPowers)
    %%% use a custom function addFastCodeTrimV4 to input Labview parameters
    %%% and output Labview readable code. Each use of this function adds
    %%% another step to the Labview code. The variables are defined in the
    %%% function file
    output = addFastCodeTrimV4(output,13,inputPowers(jy),NaN,'',NaN,NaN,NaN,jumpStep,'','changing power',pwd,identText,false);
    
    for jx = 1:length(dmdImages)
        %%% move to position on sample
        output = addFastCodeTrimV4(output,1,speed,NaN,'',(jy-1)*yStep,(jx-1)*xStep,0,jumpStep,'','move to position x and y',pwd,identText,false);
        output = addFastCodeTrimV4(output,41,stabiliseWait,NaN,'',NaN,NaN,NaN,jumpStep,'','pause for Labview to catch up',pwd,identText,false);
        
        %         maxji = jx;
        
        
        runningImage = zeros(imageSizeY,imageSizeX);
        
        for ji = 1:jx     %%% pause to avoid Labview crashing...
            
            
            currImPath = strrep(dmdImages{ji},'\\','\');
            
            
            runningImage = runningImage + numPulses*imread(currImPath);
            
            %%% load DMD image
            output = addFastCodeTrimV4(output,21,NaN,NaN,dmdImages{ji},NaN,NaN,NaN,jumpStep,'','load image',pwd,identText,false);
            
            output = addFastCodeTrimV4(output,41,stabiliseShortWait,NaN,'',NaN,NaN,NaN,jumpStep,'','pause for Labview to catch up',pwd,identText,false);
            
            
            %%% fire pulse
            output = addFastCodeTrimV4(output,12,numPulses,50,'',NaN,NaN,NaN,jumpStep,'','fire pulse',pwd,identText,false);
            
        end
        figure(1);plot(runningImage(floor(imageSizeY/2),:));
        make_figure_setSizes(1,24,3,4/3);
        xlim([-30,930]);
        ylim([-10,80]);
        plotPath = [pwd,'\plotsCircs2altVersion\square',num2str(jx),'.bmp'];
        %             saveas(gcf,plotPath);
        
        if jx == 17
            imwrite(runningImage/max(runningImage(:)),'S:\private\djh2v07\Other stuff\My papers\masters grayscale\figures\figure 3\c\profile17.png');
        end
    end
    
    
end

output = addFastCodeTrimV4(output,0,NaN,NaN,'',NaN,NaN,NaN,jumpStep,'','saving last file',pwd,identText,true);
fid = fopen([path,'\test',theDate,'_',num2str(experimentNum),'.m'], 'wt');
fprintf(fid, '%s\n', sprintf(output.string));
fclose(fid);

