%Plotting controllability show-offs

%Load cleaned data.
load showoffdataraw_v2b.mat

ylimsRS = [8e3, 5e4];
ylimsV = [-4 4];
ylimsPW = [-1e-6 1.1e-5];

%Device (14,19):
ax1 = subplot(3,3,1)
plot(Resistance1419(16380:17560), '-')
ylim(ylimsRS);
grid on
ax2 = subplot(3,3,4)
bar(AmplitudeV1419(16380:17560), 'r')
ylim(ylimsV);
grid on
ax3 = subplot(3,3,7)
plot(Pulsewidths1419(16380:17560), 'g+')
ylim(ylimsPW)

%Device (19,14):
ax4 = subplot(3,3,2)
plot(Resistance1914(3700:end), '-')
ylim(ylimsRS);
grid on
ax5 = subplot(3,3,5)
bar(AmplitudeV1914(3700:end), 'r')
ylim(ylimsV);
grid on
ax6 = subplot(3,3,8)
plot(Pulsewidths1914(3700:end), 'g+')
ylim(ylimsPW)

%Device (23,10):
ax7 = subplot(3,3,3)
plot(Resistance2222(2115:end), '-')
ylim(ylimsRS);
grid on
ax8 = subplot(3,3,6)
bar(AmplitudeV2222(2115:end), 'r')
ylim(ylimsV);
grid on
ax9 = subplot(3,3,9)
plot(Pulsewidths2222(2115:end), 'g+')
ylim(ylimsPW)


%Axis linking
linkaxes([ax1, ax2], 'x');
linkaxes([ax4, ax5], 'x');
linkaxes([ax7, ax8], 'x');