%%% Automatically process spikes.


%%% Get handle on variables.
vars = whos; %Detect all variables in workspace.
novars = length(vars); %Count variables.


%Variables, matrices and parameters.
TXLNUM = 4; %Number of texels.
thresh = 0.35; %What is the trigger level for taking a spike 'snapshot'?
startdel = 5; %Once the trigger threshold has been exceeded how many point before the system can start sampling?
sampleint = 1; %Sampling interval. Once system has started sampling in order to fill texel array, every how many points will a sample be collected?

gain = 0.1; %Gain and offset for processing spike samples. Gain: roughly from 'Offset' to some acceptable upper limit corersponding to max. attainable Vpk.
offset = 0.66; %Offset: Baseline level - should be 'far enough' down so that no significant output is observed.

j = 0; %Index of valid variables.


for i = 1:1:novars %Sweep variables.
    if strncmp(vars(i).name, 'Multiunit', 9) || strncmp(vars(i).name, 'SU_', 3) %If variable contains trace data...
        j = j + 1; %Increment valid variable index.
        varname{j} = vars(i).name; %Capture valid variable name.
        varval{j} = evalin('base', varname{j}); %Load variable with corresponding name.
        
        k = 1; %Start by looking at 1st point in recording.
        while k <= length(varval{j}) %Look at neural recording data.
            if varval{j}(k) > thresh && k+startdel+(TXLNUM-1)*sampleint <= length(varval{j}) %As soon as the threshold has been exceeded.
                for l = 1:1:TXLNUM
                    texsamps{j}(l) = varval{j}(k + startdel + (l-1)*sampleint);
                    texxs{j}(l) = k + startdel + (l-1)*sampleint; %Capture x-axis locations.
                end
                
                k = length(varval{j})+1; %Force exit from for loop.
            end
            
            k = k + 1; %Increment data point index through recording.
        end
    end
end


%Post-process & display results.

%Raw samples.
for m = 1:1:length(varname)
    display(strcat(varname{m}, ':    :', num2str(texsamps{m})))
end

%Processed samples.

%Show just resulting samples.
figure(2); %Start figure.
hold on

for m = 1:1:length(varname)
    procsamps{m} = texsamps{m}*gain + offset; %Pass samples through gain + offset processing.
    display(strcat(varname{m}, ':    :', num2str(procsamps{m})))
    
    %Colour groupping - this only works for current set of variable names.
    if strfind(varname{m}, 'ClassI_')
        str2 = 'r+-';
    elseif strfind(varname{m}, 'ClassII_')
        str2 = 'g+-';
    elseif strfind(varname{m}, 'ClassIII_')
        str2 = 'b+-';
    else
        str2 = 'k+-';
    end
    plot(procsamps{m}, str2);
end

%Show samples in context of original signals.
figure(4); %Start figure.
hold on

for m = 1:1:length(varname)
    procvals{m} = varval{m}*gain + offset; %Pass samples through gain + offset processing.
    display(strcat(varname{m}, ':    :', num2str(procsamps{m})))
    
    %Colour groupping - this only works for current set of variable names.
    if strfind(varname{m}, 'ClassI_')
        str1 = 'r-';
        str2 = 'r+';
    elseif strfind(varname{m}, 'ClassII_')
        str1 = 'g-';
        str2 = 'g+';
    elseif strfind(varname{m}, 'ClassIII_')
        str1 = 'b-';
        str2 = 'b+';
    else
        str1 = 'k-';
        str2 = 'k+';
    end
    
    plot(procvals{m}, str1);
    plot(texxs{m}, procsamps{m}, str2);
end