###R Code and Results from linear fits of 2, 3 and 4 parameter models
##written by Nicola Knight

library(boot)
dataset<-read.csv("Tambjamines_New_numbers_classified_cleaned.csv")
ds.sb<-dataset[,c('ï..Compound.no','Ring.substituent', 'NH.substituent','Enamine.Substituent','R.type','Log.1.EC50.','ALOGPs','ALOGPs.sq','nH','Mv','J3D','AMW','J','ARR','nCIC','Polarizability..cm3.')]

plot(ds.sb$ALOGPs, ds.sb$Log.1.EC50., main="Simple plot of Log(1/EC50) against ALOGPs", xlab="ALOGPs", ylab="Log(1/EC50)")
#plots ALOGPs against log(1/ec50)
# define stats function to give to boot strap, at this stage just the quadratic fit
bs <- function(formula, data, indices) {
d <- data[indices,] # allows boot to select sample
fit <- lm(formula, data=d)
return(coef(fit)) 
}
# define simpler data frame and give x and y variables
# gives dataframe with only 2 columns (the necessary columns)
df1 <-data.frame(x=ds.sb$ALOGPs,y=ds.sb$Log.1.EC50.)
# define the strata
# limits of ALOGPs are below 1.5 and above 6 in this set
strata <- ifelse(ds.sb$ALOGPs > 1.5, 1,0)+ ifelse(ds.sb$ALOGPs > 6, 1,0)
#ALOGPs, ALOGPS-sq
# do the bootstrap
res_plainfit <-boot(data = df1, statistic = bs, strata = strata, R=999, formula = y ~ x + I(x^2))
# now evaluate the confidence limit from the boot strap, index = 1 is the intercept, 2 the
# coefficient of ALOGPs and 3 the coefficient of ALOGPs^2
# bca - Adjusted Bootstrap percentile interval

boot.ci(res_plainfit, type="bca",index=1)
##result
#BOOTSTRAP CONFIDENCE INTERVAL CALCULATIONS
#Based on 999 bootstrap replicates
#CALL : 
#boot.ci(boot.out = res_plainfit, type = "bca", index = 1)
#
#Intervals : 
#Level       BCa          
#95%   (-1.1079, -0.0859 )  
#Calculations and Intervals on Original Scale
##end result

boot.ci(res_plainfit, type="bca",index=2)
##result
#BOOTSTRAP CONFIDENCE INTERVAL CALCULATIONS
#Based on 999 bootstrap replicates
#CALL : 
#boot.ci(boot.out = res_plainfit, type = "bca", index = 2)
#
#Intervals : 
#Level       BCa          
#95%   ( 0.904,  1.470 )  
#Calculations and Intervals on Original Scale
##end result

boot.ci(res_plainfit, type="bca",index=3)
##result
#BOOTSTRAP CONFIDENCE INTERVAL CALCULATIONS
#Based on 999 bootstrap replicates
#CALL : 
#boot.ci(boot.out = res_plainfit, type = "bca", index = 3)
#
#Intervals : 
#Level       BCa          
#95%   (-0.1658, -0.0926 )  
#Calculations and Intervals on Original Scale
##end result

# do the usual linear least squares for the quadratic
# lm is linear model using df1 as the data source
fitplain <- lm(y ~ x + I(x^2), data = df1)
# look at the coefficients and confidence limit from the least squares
summary(fitplain)
##result
#Call:
#lm(formula = y ~ x + I(x^2), data = df1)
#
#Residuals:
#     Min       1Q   Median       3Q      Max 
#-0.71723 -0.17356  0.02163  0.25389  0.49909 
#
#Coefficients:
#            Estimate Std. Error t value Pr(>|t|)    
#(Intercept) -0.57873    0.29008  -1.995   0.0529 .  
#x            1.20333    0.14861   8.097 5.83e-10 ***
#I(x^2)      -0.13293    0.01746  -7.613 2.67e-09 ***
#---
#Signif. codes:  0 ‘***’ 0.001 ‘**’ 0.01 ‘*’ 0.05 ‘.’ 0.1 ‘ ’ 1
#
#Residual standard error: 0.3056 on 40 degrees of freedom
#Multiple R-squared:  0.6292,	Adjusted R-squared:  0.6106 
#F-statistic: 33.93 on 2 and 40 DF,  p-value: 2.42e-09confint(fitplain)
#2.5 % 97.5 %
#(Intercept) -1.1829892 -0.008978968
#x 0.9142820 1.515710944
#I(x^2) -0.1699811 -0.099315781
##end result

confint(fitplain)
##result
#                 2.5 %      97.5 %
#(Intercept) -1.1650147  0.00754727
#x            0.9029908  1.50367778
#I(x^2)      -0.1682162 -0.09763807
##end result

#ALOGPs, ALOGPs-sq, nH
# now extend to include nH
dfnH <-data.frame(x=ds.sb$ALOGPs,y=ds.sb$Log.1.EC50., z=ds.sb$nH)
# usual least square fit and estimates
fitnH <- lm(y ~ x + I(x^2) + z, data = dfnH)

summary(fitnH)
##result
#Call:
#lm(formula = y ~ x + I(x^2) + z, data = dfnH)
#
#Residuals:
#     Min       1Q   Median       3Q      Max 
#-0.52009 -0.12461 -0.02989  0.14692  0.54953 
#
#Coefficients:
#            Estimate Std. Error t value Pr(>|t|)    
#(Intercept) -1.65858    0.30541  -5.431 3.19e-06 ***
#x            1.30991    0.11713  11.183 9.83e-14 ***
#I(x^2)      -0.17580    0.01584 -11.101 1.23e-13 ***
#z            0.06525    0.01247   5.233 5.98e-06 ***
#---
#Signif. codes:  0 ‘***’ 0.001 ‘**’ 0.01 ‘*’ 0.05 ‘.’ 0.1 ‘ ’ 1
#
#Residual standard error: 0.2372 on 39 degrees of freedom
#Multiple R-squared:  0.7822,	Adjusted R-squared:  0.7654 
#F-statistic: 46.67 on 3 and 39 DF,  p-value: 5.615e-13
##end result

confint(fitnH)
##result
#                  2.5 %     97.5 %
#(Intercept) -2.27633322 -1.0408314
#x            1.07298335  1.5468355
#I(x^2)      -0.20783293 -0.1437676
#z            0.04002894  0.0904637
##end result

# now bootstrap 
res_fitnH <-boot(data = dfnH, statistic = bs, strata = strata, R=999, formula = y ~ x + I(x^2)+z)
#res_fitnH is including nH

# look at confidence intervals
#uses the bootstrap function
# index 1 - intercept?
# index 2 - ALOGPs
# index 3 - ALOGPs^2
# index 4 - nH

boot.ci(res_fitnH, type="bca",index=1)
##result
#BOOTSTRAP CONFIDENCE INTERVAL CALCULATIONS
#Based on 999 bootstrap replicates
#
#CALL : 
#boot.ci(boot.out = res_fitnH, type = "bca", index = 1)
#
#Intervals : 
#Level       BCa          
#95%   (-2.454, -1.033 )  
#Calculations and Intervals on Original Scale
##end result

boot.ci(res_fitnH, type="bca",index=2)
##result
#BOOTSTRAP CONFIDENCE INTERVAL CALCULATIONS
#Based on 999 bootstrap replicates
#
#CALL : 
#boot.ci(boot.out = res_fitnH, type = "bca", index = 2)
#
#Intervals : 
#Level       BCa          
#95%   ( 1.038,  1.601 )  
#Calculations and Intervals on Original Scale
##end result

boot.ci(res_fitnH, type="bca",index=3)
##result
#BOOTSTRAP CONFIDENCE INTERVAL CALCULATIONS
#Based on 999 bootstrap replicates
#
#CALL : 
#boot.ci(boot.out = res_fitnH, type = "bca", index = 3)
#
#Intervals : 
#Level       BCa          
#95%   (-0.2132, -0.1302 )  
#Calculations and Intervals on Original Scale
##end result

boot.ci(res_fitnH, type="bca",index=4)
##result
#BOOTSTRAP CONFIDENCE INTERVAL CALCULATIONS
#Based on 999 bootstrap replicates
#
#CALL : 
#boot.ci(boot.out = res_fitnH, type = "bca", index = 4)
#
#Intervals : 
#Level       BCa          
#95%   ( 0.0433,  0.0874 )  
#Calculations and Intervals on Original Scale
##end result


#ALOGPs, ALOGPs-sq, Mv
# now extend to include Mv
dfMv <-data.frame(x=ds.sb$ALOGPs,y=ds.sb$Log.1.EC50., z=ds.sb$Mv)
# usual least square fit and estimates
fitMv <- lm(y ~ x + I(x^2) + z, data = dfMv)
#lines(ds.sb$ALOGPs[ord],fitted(fitMv)[ord],col="green")

summary(fitMv)
##result
#Call: lm(formula = y ~ x + I(x^2) + z, data = dfMv)
#
#Residuals:
#     Min       1Q   Median       3Q      Max 
#-0.62519 -0.09623 -0.00267  0.10307  0.50699 
#
#Coefficients:
#            Estimate Std. Error t value Pr(>|t|)    
#(Intercept)  3.36237    0.75384   4.460 6.76e-05 ***
#x            1.37214    0.11736  11.692 2.56e-14 ***
#I(x^2)      -0.15793    0.01407 -11.227 8.75e-14 ***
#z           -6.61570    1.20981  -5.468 2.83e-06 ***
#---
#Signif. codes:  0 ‘***’ 0.001 ‘**’ 0.01 ‘*’ 0.05 ‘.’ 0.1 ‘ ’ 1
#
#Residual standard error: 0.2328 on 39 degrees of freedom
#Multiple R-squared:  0.7901,	Adjusted R-squared:  0.774 
#F-statistic: 48.93 on 3 and 39 DF,  p-value: 2.732e-13
##end result

confint(fitMv)
##result
#                 2.5 %     97.5 %
#(Intercept)  1.8375883  4.8871494
#x            1.1347599  1.6095207
#I(x^2)      -0.1863835 -0.1294758
#z           -9.0627723 -4.1686238
##end result

# now bootstrap 
res_fitMv <-boot(data = dfMv, statistic = bs, strata = strata, R=999, formula = y ~ x + I(x^2)+z)
#res_fitMv is including Mv

#uses the bootstrap function
# index 1 - intercept?
# index 2 - ALOGPs
# index 3 - ALOGPs^2
# index 4 - Mv

boot.ci(res_fitMv, type="bca",index=1)
##result
#BOOTSTRAP CONFIDENCE INTERVAL CALCULATIONS
#Based on 999 bootstrap replicates
#
#CALL : 
#boot.ci(boot.out = res_fitMv, type = "bca", index = 1)
#
#Intervals : 
#Level       BCa          
#95%   ( 2.159,  4.419 )  
#Calculations and Intervals on Original Scale
##end result

boot.ci(res_fitMv, type="bca",index=2)
##result
#BOOTSTRAP CONFIDENCE INTERVAL CALCULATIONS
#Based on 999 bootstrap replicates
#
#CALL : 
#boot.ci(boot.out = res_fitMv, type = "bca", index = 2)
#
#Intervals : 
#Level       BCa          
#95%   ( 1.126,  1.579 )  
#Calculations and Intervals on Original Scale
##end result

boot.ci(res_fitMv, type="bca",index=3)
##result
#BOOTSTRAP CONFIDENCE INTERVAL CALCULATIONS
#Based on 999 bootstrap replicates
#
#CALL : 
#boot.ci(boot.out = res_fitMv, type = "bca", index = 3)
#
#Intervals : 
#Level       BCa          
#95%   (-0.1895, -0.1229 )  
#Calculations and Intervals on Original Scale
##end result

boot.ci(res_fitMv, type="bca",index=4)
##result
#BOOTSTRAP CONFIDENCE INTERVAL CALCULATIONS
#Based on 999 bootstrap replicates
#
#CALL : 
#boot.ci(boot.out = res_fitMv, type = "bca", index = 4)
#
#Intervals : 
#Level       BCa          
#95%   (-8.432, -4.473 )  
#Calculations and Intervals on Original Scale
##end result


#ALOGPs, ALOGPs-sq, J3D
# now extend to include J3D
dfJ3D <-data.frame(x=ds.sb$ALOGPs,y=ds.sb$Log.1.EC50., z=ds.sb$J3D)
# usual least square fit and estimates
fitJ3D <- lm(y ~ x + I(x^2) + z, data = dfJ3D)
#lines(ds.sb$ALOGPs[ord],fitted(fitJ3D)[ord],col="green")

summary(fitJ3D)
##result
#Call: lm(formula = y ~ x + I(x^2) + z, data = dfJ3D)
#
#Residuals:
#     Min       1Q   Median       3Q      Max 
#-0.60320 -0.11738  0.00310  0.09931  0.49719 
#
#Coefficients:
#            Estimate Std. Error t value Pr(>|t|)    
#(Intercept)  -2.3723     0.3971  -5.973 5.64e-07 ***
#x             1.3394     0.1162  11.527 3.94e-14 ***
#I(x^2)       -0.1476     0.0136 -10.850 2.42e-13 ***
#z             0.7332     0.1348   5.441 3.09e-06 ***
#---
#Signif. codes:  0 ‘***’ 0.001 ‘**’ 0.01 ‘*’ 0.05 ‘.’ 0.1 ‘ ’ 1
#
#Residual standard error: 0.2333 on 39 degrees of freedom
#Multiple R-squared:  0.7892,	Adjusted R-squared:  0.773 
#F-statistic: 48.67 on 3 and 39 DF,  p-value: 2.971e-13
##end result

confint(fitJ3D)
##result
#                 2.5 %     97.5 %
#(Intercept) -3.1755219 -1.5689714
#x            1.1043710  1.5744203
#I(x^2)      -0.1750866 -0.1200634
#z            0.4606703  1.0058329
##end result

# now bootstrap 
res_fitJ3D <-boot(data = dfJ3D, statistic = bs, strata = strata, R=999, formula = y ~ x + I(x^2)+z)
#res_fitJ3D is including J3D

# look at confidence intervals (now seem a little different to above)
#uses the bootstrap function
# index 1 - intercept?
# index 2 - ALOGPs
# index 3 - ALOGPs^2
# index 4 - J3D

boot.ci(res_fitJ3D, type="bca",index=1)
##result
#BOOTSTRAP CONFIDENCE INTERVAL CALCULATIONS
#Based on 999 bootstrap replicates
#
#CALL : 
#boot.ci(boot.out = res_fitJ3D, type = "bca", index = 1)
#
#Intervals : 
#Level       BCa          
#95%   (-3.071, -1.648 )  
#Calculations and Intervals on Original Scale
##end result

boot.ci(res_fitJ3D, type="bca",index=2)
##result
#BOOTSTRAP CONFIDENCE INTERVAL CALCULATIONS
#Based on 999 bootstrap replicates
#
#CALL : 
#boot.ci(boot.out = res_fitJ3D, type = "bca", index = 2)
#
#Intervals : 
#Level       BCa          
#95%   ( 1.109,  1.556 )  
#Calculations and Intervals on Original Scale
##end result

boot.ci(res_fitJ3D, type="bca",index=3)
##result
#BOOTSTRAP CONFIDENCE INTERVAL CALCULATIONS
#Based on 999 bootstrap replicates
#
#CALL : 
#boot.ci(boot.out = res_fitJ3D, type = "bca", index = 3)
#
#Intervals : 
#Level       BCa          
#95%   (-0.1770, -0.1145 )  
#Calculations and Intervals on Original Scale
##end result

boot.ci(res_fitJ3D, type="bca",index=4)
##result
#BOOTSTRAP CONFIDENCE INTERVAL CALCULATIONS
#Based on 999 bootstrap replicates
#
#CALL : 
#boot.ci(boot.out = res_fitJ3D, type = "bca", index = 4)
#
#Intervals : 
#Level       BCa          
#95%   ( 0.4952,  0.9602 )  
#Calculations and Intervals on Original Scale
##end result


#ALOGPs, ALOGPs-sq, ARR
# now extend to include ARR
dfARR <-data.frame(x=ds.sb$ALOGPs,y=ds.sb$Log.1.EC50., z=ds.sb$ARR)
# usual least square fit and estimates
fitARR <- lm(y ~ x + I(x^2) + z, data = dfARR)
	
summary(fitARR)
##result
#Call: lm(formula = y ~ x + I(x^2) + z, data = dfARR)
#
#Residuals:
#     Min       1Q   Median       3Q      Max 
#-0.65423 -0.09241  0.00022  0.10878  0.51673 
#
#Coefficients:
#            Estimate Std. Error t value Pr(>|t|)    
#(Intercept) -0.22238    0.24537  -0.906     0.37    
#x            1.36602    0.12449  10.973 1.73e-13 ***
#I(x^2)      -0.15271    0.01467 -10.412 8.05e-13 ***
#z           -1.67499    0.35198  -4.759 2.67e-05 ***
#---
#Signif. codes:  0 ‘***’ 0.001 ‘**’ 0.01 ‘*’ 0.05 ‘.’ 0.1 ‘ ’ 1
#
#Residual standard error: 0.2461 on 39 degrees of freedom
#Multiple R-squared:  0.7654,	Adjusted R-squared:  0.7473 
#F-statistic: 42.41 on 3 and 39 DF,  p-value: 2.358e-12
##end result

confint(fitARR)
##result
#                 2.5 %     97.5 %
#(Intercept) -0.7186996  0.2739332
#x            1.1142092  1.6178228
#I(x^2)      -0.1823700 -0.1230402
#z           -2.3869397 -0.9630480
##end result

# now bootstrap 
res_fitARR <-boot(data = dfARR, statistic = bs, strata = strata, R=999, formula = y ~ x + I(x^2)+z)
#res_fitARR is including ARR

# look at confidence intervals (now seem a little different to above)
#uses the bootstrap function
# index 1 - intercept?
# index 2 - ALOGPs
# index 3 - ALOGPs^2
# index 4 - ARR
boot.ci(res_fitARR, type="bca",index=1)
##result
#BOOTSTRAP CONFIDENCE INTERVAL CALCULATIONS
#Based on 999 bootstrap replicates
#
#CALL : 
#boot.ci(boot.out = res_fitARR, type = "bca", index = 1)
#
#Intervals : 
#Level       BCa          
#95%   (-0.6466,  0.0697 )  
#Calculations and Intervals on Original Scale
#Some BCa intervals may be unstable
##end result

boot.ci(res_fitARR, type="bca",index=2)
##result
#BOOTSTRAP CONFIDENCE INTERVAL CALCULATIONS
#Based on 999 bootstrap replicates
#
#CALL : 
#boot.ci(boot.out = res_fitARR, type = "bca", index = 2)
#
#Intervals : 
#Level       BCa          
#95%   ( 1.117,  1.605 )  
#Calculations and Intervals on Original Scale
##end result

boot.ci(res_fitARR, type="bca",index=3)
##result
#BOOTSTRAP CONFIDENCE INTERVAL CALCULATIONS
#Based on 999 bootstrap replicates
#
#CALL : 
#boot.ci(boot.out = res_fitARR, type = "bca", index = 3)
#
#Intervals : 
#Level       BCa          
#95%   (-0.1863, -0.1160 )  
#Calculations and Intervals on Original Scale
##end result

boot.ci(res_fitARR, type="bca",index=4)
##result
#BOOTSTRAP CONFIDENCE INTERVAL CALCULATIONS
#Based on 999 bootstrap replicates
#
#CALL : 
#boot.ci(boot.out = res_fitARR, type = "bca", index = 4)
#
#Intervals : 
#Level       BCa          
#95%   (-2.290, -1.065 )  
#Calculations and Intervals on Original Scale
##end result


#ALOGPs, ALOGPs-sq, AMW
# now extend to include AMW
dfAMW <-data.frame(x=ds.sb$ALOGPs,y=ds.sb$Log.1.EC50., z=ds.sb$AMW)
# usual least square fit and estimates
fitAMW <- lm(y ~ x + I(x^2) + z, data = dfAMW)

summary(fitAMW)
##result
#Call: lm(formula = y ~ x + I(x^2) + z, data = dfAMW)
#
#Residuals:
#     Min       1Q   Median       3Q      Max 
#-0.61861 -0.12959  0.02152  0.15637  0.41613 
#
#Coefficients:
#            Estimate Std. Error t value Pr(>|t|)    
#(Intercept)  0.73091    0.34409   2.124     0.04 *  
#x            1.33046    0.11940  11.143 1.09e-13 ***
#I(x^2)      -0.15404    0.01433 -10.747 3.20e-13 ***
#z           -0.19952    0.03928  -5.080 9.72e-06 ***
#---
#Signif. codes:  0 ‘***’ 0.001 ‘**’ 0.01 ‘*’ 0.05 ‘.’ 0.1 ‘ ’ 1
#
#Residual standard error: 0.2401 on 39 degrees of freedom
#Multiple R-squared:  0.7768,	Adjusted R-squared:  0.7597 
#F-statistic: 45.25 on 3 and 39 DF,  p-value: 8.955e-13
##end result

confint(fitAMW)
##result
#                  2.5 %     97.5 %
#(Intercept)  0.03492571  1.4268963
#x            1.08895355  1.5719752
#I(x^2)      -0.18302806 -0.1250454
#z           -0.27896332 -0.1200808
##end result

# now bootstrap 
res_fitAMW <-boot(data = dfAMW, statistic = bs, strata = strata, R=999, formula = y ~ x + I(x^2)+z)
#res_fitAMW is including AMW

# look at confidence intervals (now seem a little different to above)
#uses the bootstrap function
# index 1 - intercept?
# index 2 - ALOGPs
# index 3 - ALOGPs^2
# index 4 - AMW

boot.ci(res_fitAMW, type="bca",index=1)
##result
#BOOTSTRAP CONFIDENCE INTERVAL CALCULATIONS
#Based on 999 bootstrap replicates
#
#CALL : 
#boot.ci(boot.out = res_fitAMW, type = "bca", index = 1)
#
#Intervals : 
#Level       BCa          
#95%   (-0.1126,  1.3684 )  
#Calculations and Intervals on Original Scale
#Some BCa intervals may be unstable
##end result

boot.ci(res_fitAMW, type="bca",index=2)
##result
#BOOTSTRAP CONFIDENCE INTERVAL CALCULATIONS
#Based on 999 bootstrap replicates
#
#CALL : 
#boot.ci(boot.out = res_fitAMW, type = "bca", index = 2)
#
#Intervals : 
#Level       BCa          
#95%   ( 1.104,  1.536 )  
#Calculations and Intervals on Original Scale
##end result

boot.ci(res_fitAMW, type="bca",index=3)
##result
#BOOTSTRAP CONFIDENCE INTERVAL CALCULATIONS
#Based on 999 bootstrap replicates
#
#CALL : 
#boot.ci(boot.out = res_fitAMW, type = "bca", index = 3)
#
#Intervals : 
#Level       BCa          
#95%   (-0.1820, -0.1212 )  
#Calculations and Intervals on Original Scale
##end result

boot.ci(res_fitAMW, type="bca",index=4)
##result
#BOOTSTRAP CONFIDENCE INTERVAL CALCULATIONS
#Based on 999 bootstrap replicates
#
#CALL : 
#boot.ci(boot.out = res_fitAMW, type = "bca", index = 4)
#
#Intervals : 
#Level       BCa          
#95%   (-0.2931, -0.1331 )  
#Calculations and Intervals on Original Scale
#Some BCa intervals may be unstable
##end result


#ALOGPS, ALOGPs-sq, nCIC, J3D
#ALogPs, ALogPs^2, nCIC, J3D
dfnCIC_J3D <-data.frame(x=ds.sb$ALOGPs,y=ds.sb$Log.1.EC50., z=ds.sb$nCIC, w=ds.sb$J3D)
# usual least square fit and estimates
fitnCIC_J3D <- lm(y ~ x + I(x^2) + z + w, data = dfnCIC_J3D)

summary(fitnCIC_J3D)
##result
#Call: lm(formula = y ~ x + I(x^2) + z + w, data = dfnCIC_J3D)
#
#Residuals:
#     Min       1Q   Median       3Q      Max 
#-0.49204 -0.14596  0.03286  0.09284  0.47415 
#
#Coefficients:
#            Estimate Std. Error t value Pr(>|t|)    
#(Intercept)  -5.1054     1.2220  -4.178 0.000166 ***
#x             1.2837     0.1125  11.409 7.73e-14 ***
#I(x^2)       -0.1457     0.0129 -11.295 1.04e-13 ***
#z             0.4105     0.1746   2.351 0.024036 *  
#w             1.5873     0.3851   4.122 0.000196 ***
#---
#Signif. codes:  0 ‘***’ 0.001 ‘**’ 0.01 ‘*’ 0.05 ‘.’ 0.1 ‘ ’ 1
#
#Residual standard error: 0.2209 on 38 degrees of freedom
#Multiple R-squared:  0.816,	Adjusted R-squared:  0.7966 
#F-statistic: 42.12 on 4 and 38 DF,  p-value: 1.784e-13
##end result

confint(fitnCIC_J3D)
##result
#                  2.5 %     97.5 %
#(Intercept) -7.57929116 -2.6315691
#x            1.05592808  1.5114640
#I(x^2)      -0.17181680 -0.1195890
#z            0.05696876  0.7640868
#w            0.80774675  2.3668022
##end result

# now bootstrap 
res_fitnCIC_J3D <-boot(data = dfnCIC_J3D, statistic = bs, strata = strata, R=999, formula = y ~ x + I(x^2)+z +w)
#res_fitnCIC_J3D is including nCIC_J3D

# look at confidence intervals - uses the bootstrap function
# index 1 - intercept?
# index 2 - ALOGPs
# index 3 - ALOGPs^2
# index 4 - nCIC
# index 5 - J3D

boot.ci(res_fitnCIC_J3D, type="bca",index=1)
##result
#BOOTSTRAP CONFIDENCE INTERVAL CALCULATIONS
#Based on 999 bootstrap replicates
#
#CALL : 
#boot.ci(boot.out = res_fitnCIC_J3D, type = "bca", index = 1)
#
#Intervals : 
#Level       BCa          
#95%   (-7.681, -2.694 )  
#Calculations and Intervals on Original Scale
##end result

boot.ci(res_fitnCIC_J3D, type="bca",index=2)
##result
#BOOTSTRAP CONFIDENCE INTERVAL CALCULATIONS
#Based on 999 bootstrap replicates
#
#CALL : 
#boot.ci(boot.out = res_fitnCIC_J3D, type = "bca", index = 2)
#
#Intervals : 
#Level       BCa          
#95%   ( 1.087,  1.493 )  
#Calculations and Intervals on Original Scale
##end result

boot.ci(res_fitnCIC_J3D, type="bca",index=3)
##result
#BOOTSTRAP CONFIDENCE INTERVAL CALCULATIONS
#Based on 999 bootstrap replicates
#
#CALL : 
#boot.ci(boot.out = res_fitnCIC_J3D, type = "bca", index = 3)
#
#Intervals : 
#Level       BCa          
#95%   (-0.1730, -0.1161 )  
#Calculations and Intervals on Original Scale
##end result

boot.ci(res_fitnCIC_J3D, type="bca",index=4)
##result
#BOOTSTRAP CONFIDENCE INTERVAL CALCULATIONS
#Based on 999 bootstrap replicates
#
#CALL : 
#boot.ci(boot.out = res_fitnCIC_J3D, type = "bca", index = 4)
#
#Intervals : 
#Level       BCa          
#95%   ( 0.0638,  0.7957 )  
#Calculations and Intervals on Original Scale
##end result

boot.ci(res_fitnCIC_J3D, type="bca",index=5)
##result
#BOOTSTRAP CONFIDENCE INTERVAL CALCULATIONS
#Based on 999 bootstrap replicates
#
#CALL : 
#boot.ci(boot.out = res_fitnCIC_J3D, type = "bca", index = 5)
#
#Intervals : 
#Level       BCa          
#95%   ( 0.796,  2.330 )  
#Calculations and Intervals on Original Scale
##end result


#ALOGPs, ALOGPs-sq, AMW, J3D
#ALogPs, ALogPs^2, AMW, J3D
dfAMW_J3D <-data.frame(x=ds.sb$ALOGPs,y=ds.sb$Log.1.EC50., z=ds.sb$AMW, w=ds.sb$J3D)
# usual least square fit and estimates
fitAMW_J3D <- lm(y ~ x + I(x^2) + z + w, data = dfAMW_J3D)

summary(fitAMW_J3D)
##result
#Call: lm(formula = y ~ x + I(x^2) + z + w, data = dfAMW_J3D)
#
#Residuals:
#     Min       1Q   Median       3Q      Max 
#-0.58907 -0.10352  0.01421  0.08473  0.47939 
#
#Coefficients:
#            Estimate Std. Error t value Pr(>|t|)    
#(Intercept) -1.01799    0.70868  -1.436  0.15905    
#x            1.36148    0.11096  12.270 8.67e-15 ***
#I(x^2)      -0.15404    0.01325 -11.625 4.43e-14 ***
#z           -0.10996    0.04868  -2.259  0.02973 *  
#w            0.47467    0.17187   2.762  0.00881 ** 
#---
#Signif. codes:  0 ‘***’ 0.001 ‘**’ 0.01 ‘*’ 0.05 ‘.’ 0.1 ‘ ’ 1
#
#Residual standard error: 0.2219 on 38 degrees of freedom
#Multiple R-squared:  0.8141,	Adjusted R-squared:  0.7946 
#F-statistic: 41.61 on 4 and 38 DF,  p-value: 2.144e-13
##end result

confint(fitAMW_J3D)
##result
#                 2.5 %      97.5 %
#(Intercept) -2.4526500  0.41666156
#x            1.1368500  1.58610083
#I(x^2)      -0.1808690 -0.12721712
#z           -0.2085162 -0.01140107
#w            0.1267242  0.82260733
##end result

# now bootstrap 
res_fitAMW_J3D <-boot(data = dfAMW_J3D, statistic = bs, strata = strata, R=999, formula = y ~ x + I(x^2)+z +w)
#res_fitAMW_J3D is including AMW_J3D

# look at confidence intervals - uses the bootstrap function
# index 1 - intercept?
# index 2 - ALOGPs
# index 3 - ALOGPs^2
# index 4 - AMW
# index 5 - J3D

boot.ci(res_fitAMW_J3D, type="bca",index=1)
##result
#BOOTSTRAP CONFIDENCE INTERVAL CALCULATIONS
#Based on 999 bootstrap replicates
#
#CALL : 
#boot.ci(boot.out = res_fitAMW_J3D, type = "bca", index = 1)
#
#Intervals : 
#Level       BCa          
#95%   (-2.309,  0.429 )  
#Calculations and Intervals on Original Scale
##end result

boot.ci(res_fitAMW_J3D, type="bca",index=2)
##result
#BOOTSTRAP CONFIDENCE INTERVAL CALCULATIONS
#Based on 999 bootstrap replicates
#
#CALL : 
#boot.ci(boot.out = res_fitAMW_J3D, type = "bca", index = 2)
#
#Intervals : 
#Level       BCa          
#95%   ( 1.123,  1.591 )  
#Calculations and Intervals on Original Scale
##end result

boot.ci(res_fitAMW_J3D, type="bca",index=3)
##result
#BOOTSTRAP CONFIDENCE INTERVAL CALCULATIONS
#Based on 999 bootstrap replicates
#
#CALL : 
#boot.ci(boot.out = res_fitAMW_J3D, type = "bca", index = 3)
#
#Intervals : 
#Level       BCa          
#95%   (-0.1852, -0.1194 )  
#Calculations and Intervals on Original Scale
##end result

boot.ci(res_fitAMW_J3D, type="bca",index=4)
##result
#BOOTSTRAP CONFIDENCE INTERVAL CALCULATIONS
#Based on 999 bootstrap replicates
#
#CALL : 
#boot.ci(boot.out = res_fitAMW_J3D, type = "bca", index = 4)
#
#Intervals : 
#Level       BCa          
#95%   (-0.2182, -0.0512 )  
#Calculations and Intervals on Original Scale
##end result

boot.ci(res_fitAMW_J3D, type="bca",index=5)
##result
#BOOTSTRAP CONFIDENCE INTERVAL CALCULATIONS
#Based on 999 bootstrap replicates
#
#CALL : 
#boot.ci(boot.out = res_fitAMW_J3D, type = "bca", index = 5)
#
#Intervals : 
#Level       BCa          
#95%   ( 0.1479,  0.7805 )  
#Calculations and Intervals on Original Scale
##end result


#ALOGPs, ALOGPs-sq, nH, J
#ALogPs, ALogPs^2, nH, J
dfnH_J <-data.frame(x=ds.sb$ALOGPs,y=ds.sb$Log.1.EC50., z=ds.sb$nH, w=ds.sb$J)
# usual least square fit and estimates
fitnH_J <- lm(y ~ x + I(x^2) + z + w, data = dfnH_J)

summary(fitnH_J)
##result
#Call: lm(formula = y ~ x + I(x^2) + z + w, data = dfnH_J)
#
#Residuals:
#     Min       1Q   Median       3Q      Max 
#-0.51391 -0.10098 -0.02125  0.07999  0.54360 
#
#Coefficients:
#            Estimate Std. Error t value Pr(>|t|)    
#(Intercept) -3.06707    0.61117  -5.018 1.25e-05 ***
#x            1.43233    0.11898  12.039 1.55e-14 ***
#I(x^2)      -0.17239    0.01484 -11.620 4.49e-14 ***
#z            0.04414    0.01418   3.113  0.00351 ** 
#w            0.90448    0.34719   2.605  0.01304 *  
#---
#Signif. codes:  0 ‘***’ 0.001 ‘**’ 0.01 ‘*’ 0.05 ‘.’ 0.1 ‘ ’ 1
#
#Residual standard error: 0.2213 on 38 degrees of freedom
#Multiple R-squared:  0.8152,	Adjusted R-squared:  0.7957 
#F-statistic:  41.9 on 4 and 38 DF,  p-value: 1.933e-13
##end result

confint(fitnH_J)
##result
#                  2.5 %      97.5 %
#(Intercept) -4.30432090 -1.82982567
#x            1.19146973  1.67318501
#I(x^2)      -0.20242439 -0.14235652
#z            0.01543404  0.07283738
#w            0.20163869  1.60732816
##end result

# now bootstrap 
res_fitnH_J <-boot(data = dfnH_J, statistic = bs, strata = strata, R=999, formula = y ~ x + I(x^2)+z +w)
#res_fitnH_J is including nH_J

# look at confidence intervals - uses the bootstrap function
# index 1 - intercept?
# index 2 - ALOGPs
# index 3 - ALOGPs^2
# index 4 - nH
# index 5 - J
boot.ci(res_fitnH_J, type="bca",index=1)
##result
#BOOTSTRAP CONFIDENCE INTERVAL CALCULATIONS
#Based on 999 bootstrap replicates
#
#CALL : 
#boot.ci(boot.out = res_fitnH_J, type = "bca", index = 1)
#
#Intervals : 
#Level       BCa          
#95%   (-4.133, -1.767 )  
#Calculations and Intervals on Original Scale
##end result

boot.ci(res_fitnH_J, type="bca",index=2)
##result
#BOOTSTRAP CONFIDENCE INTERVAL CALCULATIONS
#Based on 999 bootstrap replicates
#
#CALL : 
#boot.ci(boot.out = res_fitnH_J, type = "bca", index = 2)
#
#Intervals : 
#Level       BCa          
#95%   ( 1.196,  1.653 )  
#Calculations and Intervals on Original Scale
##end result

boot.ci(res_fitnH_J, type="bca",index=3)
##result
#BOOTSTRAP CONFIDENCE INTERVAL CALCULATIONS
#Based on 999 bootstrap replicates
#
#CALL : 
#boot.ci(boot.out = res_fitnH_J, type = "bca", index = 3)
#
#Intervals : 
#Level       BCa          
#95%   (-0.2047, -0.1278 )  
#Calculations and Intervals on Original Scale
##end result

boot.ci(res_fitnH_J, type="bca",index=4)
##result
#BOOTSTRAP CONFIDENCE INTERVAL CALCULATIONS
#Based on 999 bootstrap replicates
#
#CALL : 
#boot.ci(boot.out = res_fitnH_J, type = "bca", index = 4)
#
#Intervals : 
#Level       BCa          
#95%   ( 0.0139,  0.0705 )  
#Calculations and Intervals on Original Scale
##end result

boot.ci(res_fitnH_J, type="bca",index=5)
##result
#BOOTSTRAP CONFIDENCE INTERVAL CALCULATIONS
#Based on 999 bootstrap replicates
#
#CALL : 
#boot.ci(boot.out = res_fitnH_J, type = "bca", index = 5)
#
#Intervals : 
#Level       BCa          
#95%   ( 0.1729,  1.4745 )  
#Calculations and Intervals on Original Scale
##end result


#ALOGPs, ALOGPs-sq, Polarizability, nH
#ALogPs, ALogPs^2, Polarizability..cm3., nH
dfPol_nH <-data.frame(x=ds.sb$ALOGPs,y=ds.sb$Log.1.EC50., z=ds.sb$Polarizability..cm3., w=ds.sb$nH)
# usual least square fit and estimates
fitPol_nH <- lm(y ~ x + I(x^2) + z + w, data = dfPol_nH)

summary(fitPol_nH)
##result
#Call: lm(formula = y ~ x + I(x^2) + z + w, data = dfPol_nH)
#
#Residuals:
#     Min       1Q   Median       3Q      Max 
#-0.57511 -0.10224 -0.02149  0.08645  0.58694 
#
#Coefficients:
#             Estimate Std. Error t value Pr(>|t|)    
#(Intercept) -0.983048   0.414418  -2.372   0.0229 *  
#x            1.306968   0.111287  11.744 3.26e-14 ***
#I(x^2)      -0.164507   0.015837 -10.387 1.18e-12 ***
#z           -0.021601   0.009462  -2.283   0.0281 *  
#w            0.062608   0.011900   5.261 5.86e-06 ***
#---
#Signif. codes:  0 ‘***’ 0.001 ‘**’ 0.01 ‘*’ 0.05 ‘.’ 0.1 ‘ ’ 1
#
#Residual standard error: 0.2253 on 38 degrees of freedom
#Multiple R-squared:  0.8084,	Adjusted R-squared:  0.7883 
#F-statistic: 40.09 on 4 and 38 DF,  p-value: 3.786e-13
##end result

confint(fitPol_nH)
##result
#                  2.5 %       97.5 %
#(Intercept) -1.82199334 -0.144102492
#x            1.08167950  1.532255543
#I(x^2)      -0.19656852 -0.132446274
#z           -0.04075559 -0.002446523
#w            0.03851716  0.086699013
##end result

fitPol_nH_pred<-fitted(fitPol_nH) #predicted values of fit3
# plot(fitPol_nH, dfPol_nH$y, main="fitPol_nH predicted vs actual") # plots predicted vs actual values

# now bootstrap 
res_fitPol_nH <-boot(data = dfPol_nH, statistic = bs, strata = strata, R=999, formula = y ~ x + I(x^2)+z +w)
#res_fitPol_nH is including Pol_nH

# look at confidence intervals - uses the bootstrap function
# index 1 - intercept?
# index 2 - ALOGPs
# index 3 - ALOGPs^2
# index 4 - Molec.Volume..cm3.
# index 5 - nH

boot.ci(res_fitPol_nH, type="bca",index=1)
##result
#BOOTSTRAP CONFIDENCE INTERVAL CALCULATIONS
#Based on 999 bootstrap replicates
#
#CALL : 
#boot.ci(boot.out = res_fitPol_nH, type = "bca", index = 1)
#
#Intervals : 
#Level       BCa          
#95%   (-1.7356,  0.0784 )  
#Calculations and Intervals on Original Scale
##end result

boot.ci(res_fitPol_nH, type="bca",index=2)
##result
#BOOTSTRAP CONFIDENCE INTERVAL CALCULATIONS
#Based on 999 bootstrap replicates
#
#CALL : 
#boot.ci(boot.out = res_fitPol_nH, type = "bca", index = 2)
#
#Intervals : 
#Level       BCa          
#95%   ( 1.032,  1.519 )  
#Calculations and Intervals on Original Scale
##end result

boot.ci(res_fitPol_nH, type="bca",index=3)
##result
#BOOTSTRAP CONFIDENCE INTERVAL CALCULATIONS
#Based on 999 bootstrap replicates
#
#CALL : 
#boot.ci(boot.out = res_fitPol_nH, type = "bca", index = 3)
#
#Intervals : 
#Level       BCa          
#95%   (-0.1990, -0.1102 )  
#Calculations and Intervals on Original Scale
##end result

boot.ci(res_fitPol_nH, type="bca",index=4)
##result
#BOOTSTRAP CONFIDENCE INTERVAL CALCULATIONS
#Based on 999 bootstrap replicates
#
#CALL : 
#boot.ci(boot.out = res_fitPol_nH, type = "bca", index = 4)
#
#Intervals : 
#Level       BCa          
#95%   (-0.0363,  0.0050 )  
#Calculations and Intervals on Original Scale
##end result

boot.ci(res_fitPol_nH, type="bca",index=5)
##result
#BOOTSTRAP CONFIDENCE INTERVAL CALCULATIONS
#Based on 999 bootstrap replicates
#
#CALL : 
#boot.ci(boot.out = res_fitPol_nH, type = "bca", index = 5)
#
#Intervals : 
#Level       BCa          
#95%   ( 0.0399,  0.0865 )  
#Calculations and Intervals on Original Scale
##end result
