// required packages
var SerialPort = require("serialport").SerialPort;
var fs = require ("fs");
var logger = require('morgan');
var express = require ('express');
var path = require('path');
var process = require('child_process').exec; 
var request = require('request');
var moment = require('moment');
var bodyParser = require('body-parser');
var util = require('util'); //for validation?
var expressValidator = require('express-validator'); //for validating input
var path = require('path');

//establish other variables 
var port = "COM4";
var serial = null;
var interval = null;
var lightOn = false;
var session_active = false;
var session_moment = null;
var session_user = null;
var filepath = null;
var laserOn = false;
var app = express();

app.use("/styles", express.static(__dirname + "/styles"));
app.use(express.static(__dirname + '/public'));
app.use(bodyParser.urlencoded({ extended: false })); 
app.use(bodyParser.json());
app.use(expressValidator());

app.use(logger('dev')); // Log the requests

app.set('view engine', 'ejs'); //use ejs, files should be in ./views/

//requests to the server for 'pages', homepage renders index.ejs
app.get('/', function(req, res) {
res.render('index', {
    session_active : session_active,
	errors: ''
});
});

app.get('/troubleshooting',function(reg,res){
	res.sendFile(__dirname + '/troubleshooting.html');
});

//post request to 'session_start' sets variables on the server
app.post('/session_start', function(req, res) {
req.assert('username', 'Please input a valid Username').isAlphanumeric();           //Validate name
var errors = req.validationErrors();  
    if( !errors){
 if(req.body.username==session_user && (moment().diff(session_moment, 'minutes')< 5) ){ //
	res.render('experiment',{ 
		session_user : session_user //sends variable to page
	}); 
} 
else //if the user is not the same, if not null then carry on
if (session_active==false){ //session not active
	session_active = true; //sets session to active
	session_moment = moment (); //sets start time
	session_user = req.body.username; //sets the session user
	lightturnOff();
	res.render('experiment',{ //renders the experiment page
		session_user : session_user
	}); 
} 
else if (moment().diff(session_moment, 'minutes') > 5){ //session_active but timed out
	session_active = true; //sets session to true 
	session_moment = moment () //sets new start time
	session_user = req.body.username; //sets the new session user
	lightturnOff();
	res.render('experiment',{
		session_user : session_user
	}); 
} 
else { //if it is active, started less than 6minutes ago.
	res.render('session_in_use'); 
};
}
    else {   //Display errors to user
        res.render('index', { 
            errors: errors[0].msg
        });
    }
});

app.get('/session_start', function(req, res){
	res.render('index', {
    session_active : session_active,
	errors : ''
	});
});

//post request to 'session_end' clears variables on the server
app.post('/session_end', function(req, res) {
session_active = false;
session_moment = null;
session_user = null;
console.log("Session Active :", session_active);
filepath = null;
res.render('end',{
});
});

app.post('/experiment', function(req, res) {
	numberread(res);
	res.setHeader("Content-Type", "text/html");
	res.write('Your Experiment is currently running, please wait a minute.'); 
});

app.get('/admin/log', function(req,res){
	console.log('Current_user: '+session_user);
	console.log('Session_active: '+session_active);
	console.log('Lights on: '+lightOn);
	console.log('Filepath set as: '+filepath);
	console.log('Laser on: '+laserOn);
	res.end();
});

app.get('/results', function(req, res) {
res.render('results');
});

//request for plot file
app.get('/plot/:filename', function(req, res) { 
	file_location = path.normalize(path.join(__dirname,filepath,req.param("filename")));
	res.download(path.join(__dirname,"matlab", filepath, req.param("filename")), function(err){
		if (err) {
			console.log('error:', err); 
			}
		else {
		console.log('plot file downloaded');
		} 
	});
});

app.get('/excelsheet/:filename', function(req, res) {
	res.download(path.join(__dirname,"matlab", filepath, req.param("filename")), function(err){
		if (err) {
			console.log('error:', err); 
			}
		else {
		console.log('excel sheet downloaded?');
		} 
	});
});

app.get('/rawimage/:filename', function(req, res) {
	res.download(path.join(__dirname,"matlab", filepath, req.param("filename")), function(err){
		if (err) {
			console.log('error:', err); 
			}
		else {
		console.log('raw image file downloaded?');
		} 
	});
});

app.post('/lightson', function(req, res) {
	res.setHeader("Content-Type", "text/html");
	lightturnOn(res);
	res.write('<br />Lights turned On');
});
app.post('/lightsoff', function(req, res) {
	res.setHeader("Content-Type", "text/html");
	lightturnOff(res);
	res.write('<br />Lights turned Off');
});

function filenumber(username, err){
fs.readFile(__dirname+'/public/matlab/currentnum.txt', 'utf-8', function (err, data) {
  if (err) throw err;
  filenumber = data + username;
});
res.end();
};

// turns on laser and calls snapshot function, with parameters
function turnOn(callback, res){
	res.write('<br />Laser turned on.');
	laserOn = true;
	serial.write ('a');
	setTimeout(function(){snapshot(turnOff, res);},10000);
   };
   
function snapshot(callback, res){
	var child = process("RobotEyez /width 2304 /height 1296 /bmp" );  
	res.write('<br />Accquiring image');
	child.stdout.on('data', function(data) {
	});
	child.stderr.on('data', function(data) {
	});
	child.on('close', function(code) {
		console.log('Snapshot closing code: ' + code);
		res.write('<br />Image Accquired.');
		setTimeout(function(){turnOff(matlab, res);},6000); 
	});
};

function turnOff(callback, res){
laserOn = false;
 serial.write ('b');
 res.write('<br />Laser turned off.');
 callback(successredirect, res); 
};

function matlab(callback, res){
var child = process("matlab -wait -nosplash -r BeerLambertRawdata('frame.bmp','"+filepath+"')" ); 
res.write('<br />Processing image in MatLab');
	child.stdout.on('data', function(data) {
});
child.stderr.on('data', function(data) {
});
child.on('close', function(code) {
    console.log('closing code: ' + code);
	res.write('<br />MatLab processing complete.');
	callback(res);
});
};

function successredirect(res){
	res.write('<br /> Finished <br />Click <a target="_parent" href="results">here</a> to get your results');
	res.end(); 
};

function numberread(res){
fs.readFile(__dirname+'/matlab/currentnum.txt', 'utf-8', function (err, data) {
  if (err) throw err;
  filenumber_string = data;
  numberupdate(filenumber_string, res);
})
};

function numberupdate(filenumber_string, res){
	newfilenumber = parseInt(filenumber_string) + 1;
	fs.writeFile(__dirname + "/matlab/currentnum.txt", newfilenumber , function(err) {
    if(err) {
	  throw err;
      console.log(err); }
    else {
      console.log("number updated, now:"+newfilenumber);
	  newfilenumber=newfilenumber+
	  setfilepath(newfilenumber, res);
	};
	})	
};

function setfilepath(newfilenumber, res){
		filepath = (newfilenumber+session_user);
		turnOn(snapshot, res); //runs the turnOn function 
};

function lightturnOn(){
	lightOn = true;
	serial.write('m');
};

function lightturnOff(){
	lightOn = false;
	serial.write('n');
};

var serial = new SerialPort (port, {baudrate:9600});
app.listen(3000);
console.log('server started');