function foldername=BeerLambertProcessing(data, filepath)
% define the parameter values for the data file location

%if there are no variables defined when the function is run it 
%should have default variables. 
if nargin < 1
data = 'frame.bmp';
end
%define the parent path

parent = 'C:\Nodejs\matlab\';

%create a new directory - with the name experiment
status = mkdir(parent,filepath);

%change the directory path to the created directory
newfolder = strcat(parent,filepath);


%Get Images

Laser1 = imread(data);
%define filename for raw image
imagepath = strcat(newfolder,'/','rawimage.jpg');
%save raw image (data) to experiment folder.
imwrite(Laser1, imagepath, 'jpg');
cd(newfolder);

%Process Data

T = numerictype;

data = squeeze(Laser1(:,:,1));
data = data(656:740,542:1520); 
x = 1:1:966; 
x1 = divide(T,x,96.6); %convert pixels to cm leaving data as distance

for ii = 1:length(x)
    profile(ii) = sum(data(:,ii));
end

Iin = max(profile);

%Make Rhodamine intensity vs Distance Plot

for ii = 1:length(x1)
    profile1(ii) = sum(data(:,ii));
end

%divide by initial intensity
for ii = 1:length(x1)
    profile1(ii) = divide(T,profile1(:,ii),Iin);
end

%log to get absorbance
for ii = 1:length(x1)
    profile1(ii) = -log(profile1(:,ii));
end

figure(1);
plot(x1,profile1);

%save plot as an image file
saveas(1, 'plot', 'jpg');

%define rows for the matrix
row1=[x1];
row2=[profile1];
A=[row1;row2];
A=A';

%export matrix as delimited file
fid = fopen('data.csv','w');
fprintf(fid,'%s\r\n','"Distance (cm)","Absorbance"');
fclose(fid);

dlmwrite('data.csv',A,'-append','delimiter',',');

close 1;

cd ..
cd ..

exit