function PSsettings = Decompose33(U)

PS9 = load('PS9');
PS39 = load('PS39');
PS21 = load('PS21');
PS34 = load('PS34');
phase9 = load('phase9');
phase21 = load('phase21');
PS9 = PS9.PS9;
PS39 = PS39.PS39;
PS21 = PS21.PS21;
PS34 = PS34.PS34;
phase9 = phase9.phase9;
phase21 = phase21.phase21;

% Generate Unitary

%U = randomUnitary(3);
% U = [1 1 1
%     1 exp(1i*2*pi/3) exp(-1i*2*pi/3)
%     1 exp(-1i*2*pi/3) exp(1i*2*pi/3)];
% U=U/sqrt(3);

% Decompose and look up values, starting with 9

distances = zeros(1,256);
phaseShifts9 = zeros(1,256);
for ii = 1:256
    PS9mat = [PS9(ii,1) PS9(ii,2)
    PS9(ii,3)*exp(1i*phase9(ii)) PS9(ii,4)*exp(1i*phase9(ii))];
    PS9matinv = inv(PS9mat);
    [xval,fval] = fminsearch(@(x) abs(U(1,2)*PS9matinv(1,2)+U(1,3)*PS9matinv(2,2)*exp(1i*x)),0);
    distances(ii) = fval;
    phaseShifts9(ii) = xval;
end
[m,ii1] = min(distances);

%Build new matrix
PhaseShift = [1 0 0
    0 1 0
    0 0 exp(1i*phaseShifts9(ii1))];
PS9mat = [PS9(ii1,1) PS9(ii1,2)
    PS9(ii1,3)*exp(1i*phase9(ii1)) PS9(ii1,4)*exp(1i*phase9(ii1))];
PS9matinv = inv(PS9mat);
PS9matinvexp = [1 0 0
    0 PS9matinv(1,1) PS9matinv(1,2)
    0 PS9matinv(2,1) PS9matinv(2,2)];

newU = U*PhaseShift*PS9matinvexp;
ii9 = ii1;

% Continue with 21

distances = zeros(1,256);
phaseShifts21 = zeros(1,256);
for ii = 1:256
    PS21mat = [PS21(ii,1) PS21(ii,2)
    PS21(ii,3)*exp(1i*phase21(ii)) PS21(ii,4)*exp(1i*phase21(ii))];
    PS21matinv = inv(PS21mat);
    [xval,fval] = fminsearch(@(x) abs(newU(1,1)*PS21matinv(1,2)*exp(1i*x)+newU(1,2)*PS21matinv(2,2)),0);
    distances(ii) = fval;
    phaseShifts21(ii) = xval;
end
[m,ii2] = min(distances);

%Build new matrix
PhaseShift = [exp(1i*phaseShifts21(ii2)) 0 0
    0 1 0
    0 0 1];
PS21mat = [PS21(ii2,1) PS21(ii2,2)
    PS21(ii2,3)*exp(1i*phase21(ii2)) PS21(ii2,4)*exp(1i*phase21(ii2))];
PS21matinv = inv(PS21mat);
PS21matinvexp = [PS21matinv(1,1) PS21matinv(1,2) 0
    PS21matinv(2,1) PS21matinv(2,2) 0
    0 0 1];

newU2 = newU*PhaseShift*PS21matinvexp;
ii21 = ii2;

% Finish with 39

distances = zeros(1,256);
phaseShifts39 = zeros(1,256);
for ii = 1:256
    PS39mat = [PS39(ii,1) PS39(ii,2)
    PS39(ii,3) PS39(ii,4)];
    PS39matinv = inv(PS39mat);
    [xval,fval] = fminsearch(@(x) abs(newU2(2,2)*PS39matinv(1,2)+newU2(2,3)*PS39matinv(2,2)*exp(1i*x)),0);
    distances(ii) = fval;
    phaseShifts39(ii) = xval;
end
[m,ii3] = min(distances);

%Build new matrix
PhaseShift34 = [1 0 0
    0 1 0
    0 0 exp(1i*phaseShifts39(ii3))];
PS39mat = [PS39(ii3,1) PS39(ii3,2)
    PS39(ii3,3) PS39(ii3,4)];
PS39matinv = inv(PS39mat);
PS39matinvexp = [1 0 0
    0 PS39matinv(1,1) PS39matinv(1,2)
    0 PS39matinv(2,1) PS39matinv(2,2)];

newU3 = newU2*PhaseShift34*PS39matinvexp;
ii39 = ii3;

% Figure out what 34 should be
targetPhase34 = -phaseShifts39(ii3);

distances = zeros(1,256);
for ii = 1:256
    distances(ii) = mod(angle(PS34(ii,4))-targetPhase34,2*pi);
end
[m,ii4] = min(distances);
ii34 = ii4;

% Now make sure this actually works

%Build all matrices
T9 = [1 0 0
    0 PS9(ii9,1) PS9(ii9,2)
    0 PS9(ii9,3)*exp(1i*phase9(ii9)) PS9(ii9,4)*exp(1i*phase9(ii9))];
T21 = [PS21(ii21,1) PS21(ii21,2) 0
    PS21(ii21,3)*exp(1i*phase21(ii21)) PS21(ii21,4)*exp(1i*phase21(ii21)) 0
    0 0 1];
T39 = [1 0 0
    0 PS39(ii39,1) PS39(ii39,2)
    0 PS39(ii39,3) PS39(ii39,4)];
PS34mat = [1 0 0
    0 1 0
    0 0 PS34(ii34,4)];

testU = newU3*T39*PS34mat*T21*T9;
phaseShiftedU = U*[exp(1i*phaseShifts21(ii21)) 0 0
    0 1 0
    0 0 exp(1i*phaseShifts9(ii9))];
% abs(testU)
% abs(phaseShiftedU)
PSsettings = [ii9,ii21,ii34,ii39];

end