%% Here, analyse chip data to produce models for the chips

%First, add the correct paths for my computer
addpath('C:\Users\clementsw\Desktop\BLOQS\ClementsData\20170913Data\Characterisation');
addpath('C:\Users\clementsw\Desktop\BLOQS\ClementsData\20170913Data\PhaseEstimation');

%% Now produce model for beam splitter 9

%Choose PS
L1 = load('20170913PS9ch11inch10out.mat');
L2 = load('20170913PS9ch12inch10out.mat');

%Find constant loss parameter that minimises the variations in total power (note: actually
%make it as sinusoidal as possible)
xloss = fminsearch(@(x) std(L1.data+x*L2.data)/mean(L1.data+x*L2.data), 1);
%plot(L1.heaterSettings,L1.data,L1.heaterSettings,xloss*L2.data,L1.heaterSettings,L1.data+xloss*L2.data)
%xloss = 1.2;

%Remove background (otherwise data makes no sense). This step is a bit arbitrary since I don't really know
%what the background actually is
L1.data = L1.data - 0.75*ones(1,size(L1.data,2))*min(L1.data);
L2.data = L2.data - 1*ones(1,size(L2.data,2))*min(L2.data);


%Nomalize
xAxis = L1.heaterSettings;
t1 = L1.data./(L1.data+xloss*L2.data);
t2 = xloss*L2.data./(L1.data+xloss*L2.data);

%Interpolate
PWMsettings = 0:255;
t1adj = spline(xAxis,t1,PWMsettings);
t2adj = spline(xAxis,t2,PWMsettings);
% for ii = 1:256
%    if t1adj(ii) + t2adj(ii) > 1
%        t1adj(ii) = t1adj(ii)./(t1adj(ii) + t2adj(ii));
%        t2adj(ii) = t2adj(ii)./(t1adj(ii) + t2adj(ii));
%    end
% end

plot(PWMsettings,t1adj,PWMsettings,t2adj,PWMsettings,t1adj+t2adj)
ylim([0 1])

%Produce list of matrices
PS9 = zeros(256,4);
for ii = 1:256
    PS9(ii,1) = sqrt(t1adj(ii)); %1 to 1
    PS9(ii,2) = 1i*sqrt(t2adj(ii)); %2 to 1
    PS9(ii,3) = 1i*sqrt(t2adj(ii)); %1 to 2
    PS9(ii,4) = sqrt(t1adj(ii)); %2 to 2
end

%plot(PS39(:,1).^2 + abs(PS39(:,2)).^2)

%% Save look up table
save('PS9','PS9')

%% Now produce model for beam splitter 39

%Choose PS
L1 = load('20170913PS39ch10inch11out.mat');
L2 = load('20170913PS39ch10inch12out.mat');

%Find constant loss parameter that minimises the variations in total power
xloss = fminsearch(@(x) std(L1.data+x*L2.data)/mean(L1.data+x*L2.data), 1)
%plot(L1.heaterSettings,L1.data,L1.heaterSettings,xloss*L2.data,L1.heaterSettings,L1.data+xloss*L2.data)

%normalise
xAxis = L1.heaterSettings;
t1 = L1.data/max(L1.data+xloss*L2.data);
t2 = xloss*L2.data/max(L1.data+xloss*L2.data);

%Interpolate
PWMsettings = 0:255;
t1adj = spline(xAxis,t1,PWMsettings);
t2adj = spline(xAxis,t2,PWMsettings);
for ii = 1:256
   if t1adj(ii) + t2adj(ii) > 1
       t1adj(ii) = t1adj(ii)./(t1adj(ii) + t2adj(ii));
       t2adj(ii) = t2adj(ii)./(t1adj(ii) + t2adj(ii));
   end
end

plot(PWMsettings,t1adj,PWMsettings,t2adj,PWMsettings,t1adj+t2adj)

%Create matrices
PS39 = zeros(256,4);
for ii = 1:256
    PS39(ii,1) = sqrt(t1adj(ii)); %1 to 1
    PS39(ii,2) = 1i*sqrt(t2adj(ii)); %2 to 1
    PS39(ii,3) = 1i*sqrt(t2adj(ii)); %1 to 2
    PS39(ii,4) = sqrt(t1adj(ii)); %2 to 2
end

%plot(PS39(:,1).^2 + abs(PS39(:,2)).^2)

%% Save look up table
save('PS39','PS39')

%% Now produce model for beam splitter 21

L1 = load('20170913PS21ch11inch10out.mat');

%Remove background (otherwise data makes no sense). Once again, this is a bit arbitray and the background
%also seems to be phase dependent so I have to adjust that too.
for ii = 1:size(L1.data,2)
    L1.data(ii) = L1.data(ii) + 0.25*max(L1.data)*(256-ii)/256;
end

L1.data = L1.data - 0.8*ones(1,size(L1.data,2))*min(L1.data);

%Normalise and produce the conjugate data set since I can't measure it
%directly
xAxis = L1.heaterSettings;
t1 = L1.data/max(L1.data);
t2 = ones(1,size(L1.heaterSettings,2)) - t1;

%Interpolate
PWMsettings = 0:255;
t1adj = spline(xAxis,t1,PWMsettings);
t2adj = spline(xAxis,t2,PWMsettings);
for ii = 1:256
   if t1adj(ii) < 0
       t1adj(ii) = 0;
   end
   if t2adj(ii) < 0
       t2adj(ii) = 0;
   end
   if t1adj(ii) + t2adj(ii) > 1
       t1adj(ii) = t1adj(ii)./(t1adj(ii) + t2adj(ii));
       t2adj(ii) = t2adj(ii)./(t1adj(ii) + t2adj(ii));
   end
end

plot(PWMsettings,t1adj,PWMsettings,t2adj,PWMsettings,t1adj+t2adj)

%Make matrices
PS21 = zeros(256,4);
for ii = 1:256
    PS21(ii,1) = sqrt(t2adj(ii)); %1 to 1
    PS21(ii,2) = 1i*sqrt(t1adj(ii)); %2 to 1
    PS21(ii,3) = 1i*sqrt(t1adj(ii)); %1 to 2
    PS21(ii,4) = sqrt(t2adj(ii)); %2 to 2
end

%% Save look up table
save('PS21','PS21')

%% Now do phase shifts for 11 to 11, starting with 9

PS9 = load('PS9');
PS39 = load('PS39');
PS21 = load('PS21');
PS9 = PS9.PS9;
PS39 = PS39.PS39;
PS21 = PS21.PS21;

settings9 = 0:20:240;
offsetArray = zeros(1,13);

%Determine what phase is introduced into the system, by scanning PS34 for
%different settings of MZI9
nineto0 = load('20170913PS34ch11inch11out_9setTo0.mat');
params_90 = sinefit(nineto0.heaterSettings,nineto0.data);
offsetArray(1) = params_90(4)+pi/2;

nineto20 = load('20170913PS34ch11inch11out_9setTo20.mat');
params_920 = sinefit(nineto20.heaterSettings,nineto20.data);
offsetArray(2) = params_920(4)+pi/2;

nineto40 = load('20170913PS34ch11inch11out_9setTo40.mat');
params_940 = sinefit(nineto40.heaterSettings,nineto40.data);
offsetArray(3) = params_940(4)+pi/2;

nineto60 = load('20170913PS34ch11inch11out_9setTo60.mat');
params_960 = sinefit(nineto60.heaterSettings,nineto60.data);
offsetArray(4) = params_960(4)+pi/2;

nineto80 = load('20170913PS34ch11inch11out_9setTo80.mat');
params_980 = sinefit(nineto80.heaterSettings,nineto80.data);
offsetArray(5) = params_980(4)+pi/2;

nineto100 = load('20170913PS34ch11inch11out_9setTo100.mat');
params_9100 = sinefit(nineto100.heaterSettings,nineto100.data);
offsetArray(6) = params_9100(4)+pi/2;

nineto120 = load('20170913PS34ch11inch11out_9setTo120.mat');
params_9120 = sinefit(nineto120.heaterSettings,nineto120.data);
offsetArray(7) = params_9120(4)+pi/2;

nineto140 = load('20170913PS34ch11inch11out_9setTo140.mat');
params_9140 = sinefit(nineto140.heaterSettings,nineto140.data);
offsetArray(8) = params_9140(4)+pi/2;

nineto160 = load('20170913PS34ch11inch11out_9setTo160.mat');
params_9160 = sinefit(nineto160.heaterSettings,nineto160.data);
offsetArray(9) = params_9160(4)+pi/2;

nineto180 = load('20170913PS34ch11inch11out_9setTo180.mat');
params_9180 = sinefit(nineto180.heaterSettings,nineto180.data);
offsetArray(10) = params_9180(4)+pi/2;

nineto200 = load('20170913PS34ch11inch11out_9setTo200.mat');
params_9200 = sinefit(nineto200.heaterSettings,nineto200.data);
offsetArray(11) = params_9200(4)+pi/2;

nineto220 = load('20170913PS34ch11inch11out_9setTo220.mat');
params_9220 = sinefit(nineto220.heaterSettings,nineto220.data);
offsetArray(12) = params_9220(4)+pi/2;

nineto240 = load('20170913PS34ch11inch11out_9setTo240.mat');
params_9240 = sinefit(nineto240.heaterSettings,nineto240.data);
offsetArray(13) = params_9240(4)+pi/2;

%correct for 2pi phase shifts
for ii = 7:13
    offsetArray(ii) = offsetArray(ii) - 2*pi;
%     if offsetArray(ii) < 0
%         offsetArray(ii) = offsetArray(ii) + 2*pi;
%     end
end

%Interpolate
phase9 = interp1(settings9,offsetArray,PWMsettings,'pchip');
plot(PWMsettings,phase9,settings9,offsetArray,'x')

%% Save data
save('phase9','phase9')

%% Now do phase shift for 21

PS9 = load('PS9');
PS39 = load('PS39');
PS21 = load('PS21');
PS9 = PS9.PS9;
PS39 = PS39.PS39;
PS21 = PS21.PS21;

settings21 = 0:20:240;
offsetArray = zeros(1,13);

twentyoneto0 = load('20170913PS34ch11inch11out_21setTo0.mat');
params_210 = sinefit(twentyoneto0.heaterSettings,twentyoneto0.data);
offsetArray(1) = params_210(4);

twentyoneto20 = load('20170913PS34ch11inch11out_21setTo20.mat');
params_2120 = sinefit(twentyoneto20.heaterSettings,twentyoneto20.data);
offsetArray(2) = params_2120(4);

twentyoneto40 = load('20170913PS34ch11inch11out_21setTo40.mat');
params_2140 = sinefit(twentyoneto40.heaterSettings,twentyoneto40.data);
offsetArray(3) = params_2140(4);

twentyoneto60 = load('20170913PS34ch11inch11out_21setTo60.mat');
params_2160 = sinefit(twentyoneto60.heaterSettings,twentyoneto60.data);
offsetArray(4) = params_2160(4);

twentyoneto80 = load('20170913PS34ch11inch11out_21setTo80.mat');
params_2180 = sinefit(twentyoneto80.heaterSettings,twentyoneto80.data);
offsetArray(5) = params_2180(4);

twentyoneto100 = load('20170913PS34ch11inch11out_21setTo100.mat');
params_21100 = sinefit(twentyoneto100.heaterSettings,twentyoneto100.data);
offsetArray(6) = params_21100(4);

twentyoneto120 = load('20170913PS34ch11inch11out_21setTo120.mat');
params_21120 = sinefit(twentyoneto120.heaterSettings,twentyoneto120.data);
offsetArray(7) = params_21120(4);

twentyoneto140 = load('20170913PS34ch11inch11out_21setTo140.mat');
params_21140 = sinefit(twentyoneto140.heaterSettings,twentyoneto140.data);
offsetArray(8) = params_21140(4);

twentyoneto160 = load('20170913PS34ch11inch11out_21setTo160.mat');
params_21160 = sinefit(twentyoneto160.heaterSettings,twentyoneto160.data);
offsetArray(9) = params_21160(4);

twentyoneto180 = load('20170913PS34ch11inch11out_21setTo180.mat');
params_21180 = sinefit(twentyoneto180.heaterSettings,twentyoneto180.data);
offsetArray(10) = params_21180(4);

twentyoneto200 = load('20170913PS34ch11inch11out_21setTo200.mat');
params_21200 = sinefit(twentyoneto200.heaterSettings,twentyoneto200.data);
offsetArray(11) = params_21200(4);

twentyoneto220 = load('20170913PS34ch11inch11out_21setTo220.mat');
params_21220 = sinefit(twentyoneto220.heaterSettings,twentyoneto220.data);
offsetArray(12) = params_21220(4);

twentyoneto240 = load('20170913PS34ch11inch11out_21setTo240.mat');
params_21240 = sinefit(twentyoneto240.heaterSettings,twentyoneto240.data);
offsetArray(13) = params_21240(4);

%correct for 2pi phase shifts
for ii = 6:13
%     if offsetArray(ii) < 0
%         offsetArray(ii) = offsetArray(ii) + 2*pi;
%     end
offsetArray(ii) = offsetArray(ii) + 2*pi;
end

%Interpolate
phase21 = interp1(settings21,offsetArray,PWMsettings,'pchip');
phase21 = phase21 - (phase21(151))*ones(1,256);
plot(PWMsettings,phase21)

%% Save data
save('phase21','phase21')

%% Now model 34. I just need to figure out what the period of the sinusoid is
avgMod1 = mean([params_90(3) params_920(3) params_940(3) params_960(3) params_980(3) params_9100(3) params_9120(3) params_9140(3) params_9160(3) params_9180(3) params_9200(3) params_9220(3) params_9240(3)]);
avgMod2 = mean([params_210(3) params_2120(3) params_2140(3) params_2160(3) params_2180(3) params_21100(3) params_21120(3) params_21140(3) params_21160(3) params_21180(3) params_21200(3) params_21220(3) params_21240(3)]);
avgMod = mean([avgMod1 avgMod2]); %average observed sinusoid

PS34 = zeros(256,4);
for ii = 1:256
    PS34(ii,1) = 1; %1 to 1
    PS34(ii,2) = 0; %2 to 1
    PS34(ii,3) = 0; %1 to 2
    PS34(ii,4) = exp(1i*2*pi*ii/avgMod); %2 to 2
end

%% Save model for 34
save('PS34','PS34')

%% Testing to see if model and data work together

PS9 = load('PS9');
PS39 = load('PS39');
PS21 = load('PS21');
PS34 = load('PS34');
phase9 = load('phase9');
phase21 = load('phase21');
PS9 = PS9.PS9;
PS39 = PS39.PS39;
PS21 = PS21.PS21;
PS34 = PS34.PS34;
phase9 = phase9.phase9;
phase21 = phase21.phase21;

L = load('20170913PS34ch11inch11out_9setTo100.mat');
set9 = 100;
set39 = 112;
set21 = 150;

PS9mat = [PS9(1+set9,1) PS9(1+set9,2)
    PS9(1+set9,3)*exp(1i*phase9(1+set9)) PS9(1+set9,4)*exp(1i*phase9(1+set9))];

PS39mat = [PS39(1+set39,1) PS39(1+set39,2)
    PS39(1+set39,3) PS39(1+set39,4)];

PS21mat = [PS21(1+set21,4) 0
    0 max(PS21(:,4))*exp(1i*phase21(1+set21))];

data1=zeros(1,256);
data2=zeros(1,256);
input = [1,0]';
for ii = 1:256
    M34 = [1 0
        0 PS34(ii,4)];
    output = PS39mat*M34*PS21mat*PS9mat*input;
    data1(ii) = abs(output(1))^2;
    data2(ii) = abs(output(2))^2;
end
%data1 = data1/(max(data1+data2));
%plot(1:256,data1,1:256,data2)

%Add background
data1 = data1 + 0.1*ones(1,256);

plot(1:256,data1/max(data1),L.heaterSettings,L.data/max(L.data))
ylim([0 1])

%% Testing: can I figure out what the background actually is? Not really...

PS39 = load('PS39');
PS21 = load('PS21');
PS34 = load('PS34');
phase9 = load('phase9');
phase21 = load('phase21');
PS39 = PS39.PS39;
PS21 = PS21.PS21;
PS34 = PS34.PS34;
phase9 = phase9.phase9;
phase21 = phase21.phase21;

set39 = 112;
set21 = 150;

%This code allows me to determine maximum splitting ratios
PS39mat = [PS39(1+set39,1) PS39(1+set39,2)
    PS39(1+set39,3) PS39(1+set39,4)];
PWMsettings = 0:255;
set9 = 0;
L = load('20170913PS34ch11inch11out_9setTo0.mat');
newL = spline(L.heaterSettings,L.data,PWMsettings);
[t0, fval] = fminsearchbnd(@(x) distanceToFit(x,newL/max(newL),PS39mat,PS34,phase9(set9+1)),0.1,0,1);
t0
PS9mat = [sqrt(t0) 1i*sqrt(1-t0),
    1i*sqrt(1-t0)*exp(1i*phase9(set9+1)) sqrt(t0)*exp(1i*phase9(set9+1))];
data=zeros(1,256);
input = [1,0]';
for ii = 1:256
    M34 = [1 0
        0 PS34(ii,4)];
    output = PS39mat*M34*PS9mat*input;
    data(ii) = abs(output(1))^2;
end
data = data/max(data);
plot(1:256,newL/max(newL),1:256,data)
