from abaqus import *
from abaqusConstants import *
from step import *


def Step(**kwargs):
    """
    Create buckling analysis and define all the parameters

    :param kwargs: model parameters

    :type kwargs: dict

    :return: Null

    :rtype: Null
    """
    # Define a standard buckling step with Subspace solver
    modelname = kwargs['modelname']
    StepName = kwargs['StepName']
    NumberOfEigs = kwargs['NumberOfEigs']
    mdb.models[modelname].BuckleStep(name=StepName,
                                     previous='Initial',
                                     numEigen=NumberOfEigs,
                                     vectors=2*NumberOfEigs,
                                     maxIterations=300)
    # Create a list of output variables
    mdb.models[modelname].FieldOutputRequest(
        name='output', createStepName=StepName,
        variables=(
            'S', 'MISES', 'MISESMAX', 'TSHR', 'CTSHR', 'ALPHA', 'TRIAX', 'VS', 'PS',
            'CS11', 'SSAVG', 'MISESONLY', 'PRESSONLY', 'E', 'VE', 'PE', 'VEEQ', 'PEEQ',
            'PEEQT', 'PEEQMAX', 'PEMAG', 'PEQC', 'EE', 'IE', 'THE', 'NE', 'LE', 'ER',
            'SE', 'SPE', 'SEPE', 'SEE', 'SEP', 'SALPHA', 'U', 'ENER', 'ELEN',
            'ELEDEN'))
