# Welcome to the Spindle FEA application repository

![Screenshot](spindle.jpg)

[![License](https://img.shields.io/badge/License-MIT-blue.svg)](https://opensource.org/licenses/MIT)
[![Platform](https://img.shields.io/badge/platform-win--64-brightgreen.svg)](https://www.microsoft.com/en-us/software-download/windows10ISO)
[![Python](https://img.shields.io/badge/python-2.7-blue.svg)](https://www.python.org/download/releases/2.7/)
[![Dependencies](https://img.shields.io/badge/dependencies-Abaqus%20CAE-red.svg)](https://www.3ds.com/products-services/simulia/products/abaqus/abaquscae/)

Spindle FEA application is designed to employ continuous mechanics principles using the Abaqus CAE finite element code to study buckling of the mitotic spindle as a whole in various phases of mitosis.

## Installation instructions

1. The application requires Abaqus CAE to be installed. It can be acquired from here: https://www.3ds.com/products-services/simulia/products/abaqus/abaquscae
2. Clone or download this repository

## Running the analysis

1. The interactive documentation to this application with the step-by-step guide on how to run the application is located in ```/docs/build/html/index.html```.
2. To run the simplest test you need to navigate to the root of this directory and execute ```Abaqus cae noGUI=job.py``` in the command line or, alternatively, run ``job.py`` as a script in Abaqus GUI.
3. After the solver finishes the task you will be able to open the ```Job-1.odb``` file in the Abaqus CAE graphical user interface. The detailed information about the analysis you can also find in ```Job-1.dat``` file.
4. For more advanced control of the application refer to the documentation.

## License

The [MIT license](http://opensource.org/licenses/MIT).
