from abaqus import *
from abaqusConstants import *
import mesh


def standard_mesh(**kwargs):
    """
    Generates finite element mesh on each instance of the Mitotic spindle assembly

    :param kwargs: model parameters

    :type kwargs: object

    :return: Null

    :rtype: Null
    """
    modelname = kwargs['modelname']
    a = mdb.models[modelname].rootAssembly
    connectorNames = kwargs['ConnectorData'].keys()
    aMTnames = kwargs['aMTnames']
    ipMTnames = kwargs['ipMTnames']
    for name in connectorNames:
        a.makeDependent(instances=(a.instances[name],))
    for name in aMTnames:
        a.makeDependent(instances=(a.instances[name],))
    a.makeDependent(instances=(a.instances['centrosome-right'],
                               a.instances['centrosome-left']))
    for name in ipMTnames:
        a.makeDependent(instances=(a.instances[name],))

    # Connector
    for name in connectorNames:
        p = mdb.models[modelname].parts[name]
        p.seedPart(size=0.005, deviationFactor=0.1, minSizeFactor=0.1)
        elemType1 = mesh.ElemType(elemCode=B32, elemLibrary=STANDARD)
        e = p.edges
        edges = e.getSequenceFromMask(mask=('[#1 ]', ), )
        pickedRegions =(edges, )
        p.setElementType(regions=pickedRegions, elemTypes=(elemType1, ))
        p.generateMesh()

    # aMT
    for name in aMTnames:
        p = mdb.models[modelname].parts[name]
        p.seedPart(size=0.1, deviationFactor=0.1, minSizeFactor=0.1)
        elemType1 = mesh.ElemType(elemCode=B32, elemLibrary=STANDARD)
        e = p.edges
        edges = e.getSequenceFromMask(mask=('[#1 ]', ), )
        pickedRegions =(edges, )
        p.setElementType(regions=pickedRegions, elemTypes=(elemType1, ))
        p.generateMesh()

    # Centrosome
    p = mdb.models[modelname].parts['centrosome']
    p.seedPart(size=0.03, deviationFactor=0.1, minSizeFactor=0.1)
    c = p.cells
    cells = c.getSequenceFromMask(mask=('[#1 ]', ), )
    pickedRegions =(cells, )
    elemType1 = mesh.ElemType(elemCode=C3D20R, elemLibrary=STANDARD)
    elemType2 = mesh.ElemType(elemCode=C3D15, elemLibrary=STANDARD)
    elemType3 = mesh.ElemType(elemCode=C3D10, elemLibrary=STANDARD)
    p.setElementType(regions=pickedRegions, elemTypes=(elemType1, elemType2,
        elemType3))
    c = p.cells
    pickedRegions = c.getSequenceFromMask(mask=('[#1 ]', ), )
    p.setMeshControls(regions=pickedRegions, elemShape=TET, technique=FREE)
    p.generateMesh()

    # ipMT
    for name in ipMTnames:
        p = mdb.models[modelname].parts[name]
        p.seedPart(size=0.1, deviationFactor=0.1, minSizeFactor=0.1)
        elemType1 = mesh.ElemType(elemCode=B32, elemLibrary=STANDARD)
        e = p.edges
        edges = e.getSequenceFromMask(mask=('[#1 ]', ), )
        pickedRegions =(edges, )
        p.setElementType(regions=pickedRegions, elemTypes=(elemType1, ))
        p.generateMesh()


