"""
This is the main input file for the analysis. Provide all the geometric and physical properties of the mitotic
spindle in the dictionary ``kwargs``. You can also adjust the solver parameters and request parallelization of
computations by changing ``mdb.Job()`` parameters.
"""
from abaqus import *
from abaqusConstants import *
import __main__
from LoadCase import Interaction
from LoadCase import Step
from LoadCase import LoadsAndBCs
from SpindleMesh import generate_mesh

if __name__ == '__main__':
    ''' User input parameters '''
    kwargs = {'x'               : 0,
              'y'               : 0,
              'index'           : 0,
              'modelname'       : 'test',
              'assembly'        : 0,
              'CentrosomeRadius': 0.12,
              'CentrosomeLength': 0.24,
              'CentrosomeE'     : 1500000000.0,
              'CentrosomeNu'    : 0.3,
              'ipMTnumber'      : 6,
              'lengthInterval'  : [2, 5],
              'separation'      : [0.02876, 0.0414],
              'angle'           : [96.39, 11.12],
              'd'               : 0.015,
              'D'               : 0.025,
              'ElasticModulus'  : 1500000000.0,
              'PoissonRatio'    : 0.3,
              'spindleLength'   : 10,
              'Nconnectors'     : 10,
              'connectorRadius' : 0.005,
              'connectorE'      : 1500000000.,
              'connectorNu'     : 0.3,
              'aMTnumber'       : 20,
              'aMTlength'       : 2,
              'aMTsSpring'      : 10,
              'groundSpring'    : 10,
              'StepName'        : 'Standard_Buckling',
              'NumberOfEigs'    : 5,
              'CompressiveLoad' : 1,
              'JobName'         : 'Job-1'}

    ''' Call model functions '''
    kwargs, data = Interaction.create_interactions(**kwargs)
    Step.Step(**kwargs)
    LoadsAndBCs.create_load(data, **kwargs)
    LoadsAndBCs.create_bc(**kwargs)
    generate_mesh.standard_mesh(**kwargs)

    ''' Create and submit job '''
    name = kwargs['JobName']
    modelname = kwargs['modelname']
    mdb.Job(name=name, model=modelname, description='', type=ANALYSIS, atTime=None,
            waitMinutes=0, waitHours=0, queue=None, memory=90,
            memoryUnits=PERCENTAGE, getMemoryFromAnalysis=True,
            explicitPrecision=SINGLE, nodalOutputPrecision=SINGLE, echoPrint=OFF,
            modelPrint=OFF, contactPrint=OFF, historyPrint=OFF, userSubroutine='',
            scratch='', resultsFormat=ODB, multiprocessingMode=DEFAULT, numCpus=1,
            numGPUs=0)
    mdb.jobs[name].submit(consistencyChecking=OFF)
