function  disp = func_fixNaNsInDispX(extrapOpts,disp)
% Author: Lloyd Fletcher
% PhotoDyn Group, University of Southampton
% Date: 20/6/2017
%
% Finds NaNs in the displacement fields and replace them with local
% averages

% Find the location of all the NaNs in the arrays
[y,x,t] = ind2sub(size(disp),find(isnan(disp)));
numNans = length(x);

for i = 1:numNans
   xRange = x(i);

   yRange = y(i)-1-2*extrapOpts.fixNaNKernal:y(i);
   if min(yRange) < 1
       yRange = 1:y(i)+1+2*extrapOpts.fixNaNKernal;
   elseif max(yRange) > size(disp,1)
       yRange = y(i)-2*extrapOpts.fixNaNKernal:size(disp,1); 
   end
   
   checkMean = squeeze(nanmean(nanmean(disp(yRange,xRange,t(i)))));
   disp(y(i),x(i),t(i)) = checkMean;  
end

end

