function  disp = func_fixNaNsInDispY(extrapOpts,disp)
% Author: Lloyd Fletcher
% PhotoDyn Group, University of Southampton
% Date: 20/6/2017
%
% Finds NaNs in the displacement fields and replace them with local
% averages

% Find the location of all the NaNs in the arrays
[y,x,t] = ind2sub(size(disp),find(isnan(disp)));
numNans = length(x);

for i = 1:numNans
   yRange = y(i);

   xRange = x(i):x(i)+2*extrapOpts.fixNaNKernal;
   if min(xRange) < 1
       xRange = 1:x(i)+2*extrapOpts.fixNaNKernal;
   elseif max(xRange) > size(disp,2)
       xRange = x(i)-2*extrapOpts.fixNaNKernal:size(disp,2); 
   end
   
   checkMean = squeeze(nanmean(nanmean(disp(yRange,xRange,t(i)))));
   disp(y(i),x(i),t(i)) = checkMean;  
end

end

