function [identStiffness,linearFitCoeffs,QFit,QGOF] = func_identStiffLinFitStressStrainCurve(identOpts,stressAvg,strainAvg)
% Author: Lloyd Fletcher
% PhotoDyn Group, University of Southampton
% Date: 9/2/2018
%
% Linearly fits the stressAvg vs strainAvg to obtain the stiffness

% Specify the range over which the fit is performed
if strcmp(identOpts.fitRangeOpt,'componly')
    for xx = 1:size(stressAvg,1)
        [~,minInd] = min(stressAvg(xx,:));
        tRange{xx} = identOpts.fitDefaultRange(1):minInd;
    end
elseif strcmp(identOpts.fitRangeOpt,'tensonly')
    for xx = 1:size(stressAvg,1)
        [~,maxInd] = max(stressAvg(xx,:));
        tRange{xx} = identOpts.fitDefaultRange(1):maxInd;
    end
elseif strcmp(identOpts.fitRangeOpt,'maxabs')
    for xx = 1:size(stressAvg,1)
        [minS,minInd] = min(stressAvg(xx,:));
        [maxS,maxInd] = max(stressAvg(xx,:));

        if abs(minS) > abs(maxS)
             tRange{xx} = identOpts.fitDefaultRange(1):minInd;
        else
             tRange{xx} = identOpts.fitDefaultRange(1):maxInd;
        end
    end
else
    for xx = 1:size(stressAvg,1)
        tRange{xx} = identOpts.fitDefaultRange;
    end
end

% Specify algorithm for linear fit
if identOpts.robustFit
    options = fitoptions('Method','LinearLeastSquares','Robust','On');
else
    options = fitoptions('Method','LinearLeastSquares','Robust','Off');
end

% Pre-alloc Qxx vars for speed
QFit = cell(1,size(stressAvg,1));
QGOF = cell(1,size(stressAvg,1));
identStiffness = zeros(1,size(stressAvg,1));

for xx = 1:size(stressAvg,1)
    % Make sure there are enough points to linearly fit
    if length(tRange{xx}) >= 2

       [QFit{xx},QGOF{xx}] = fit(strainAvg(xx,tRange{xx})',...
           stressAvg(xx,tRange{xx})','poly1',options);
 
       identStiffness(xx) = QFit{xx}.p1;
       linearFitCoeffs{xx} = [QFit{xx}.p1,QFit{xx}.p2]; 
    else
       % If there are not enough points return 0 stiffness
       % fprintf('WARNING: not enough points for a linear fit of stress-strain curve.\n')
       identStiffness(xx) = 0;
       linearFitCoeffs{xx} = [0,0];
    end
end
    
end

