function [stressXAvg,accelSurfAvg] = func_stressGaugeProcess(material,time,pos,accel,dataType)
% Author: Lloyd Fletcher
% PhotoDyn Group, University of Southampton
% Date: 9/2/2017
%
% Processes width averaged accel data to obtain stress 
% sigma(x,t),lineAvg = material.rho*x*a(x,t),areaAvg

% If type is unspecified assume this is a grid not nodal FE data
if nargin < 5
    dataType = 'grid';
end

pos.xStep = pos.x(2) - pos.x(1);
%Pre-alloc for speed
stressXAvg = zeros(size(accel.xAvg));
if strcmp(dataType,'grid')
    for t = 1:time.numFrames
        for x = 1:length(pos.x)       
            % average accel averaged from free end (x = 0) to x
            accelSurfAvg(x,t) = mean(accel.xAvg(1:x,t));
            % reconstructed stress on a line at x
            stressXAvg(x,t) = material.rho*(pos.x(x)+pos.xStep/2)*accelSurfAvg(x,t); 
        end
    end
else
     for t = 1:time.numFrames
        for x = 1:length(pos.x)       
            % average accel averaged from free end (x = 0) to x
            accelSurfAvg(x,t) = mean(accel.xAvg(1:x,t));
            % reconstructed stress on a line at x
            stressXAvg(x,t) = material.rho*pos.x(x)*accelSurfAvg(x,t); 
        end
    end
end

