function dispInterp = f_shapeFunctionInterpolant_Phase(pos,varFit,meshShapeFunctions,mX,mY,range,mask)
% load sample data
% clc
% clear
% 
% load('D:\PhD Southampton\MATLAB\ImageDeformation_TT_Tension\PadEdgeDebug_SampleData.mat');
% 
% clearvars except disp pos
% disp.x = SampleData.dispx;
% pos = SampleData.pos;
% 
% cropPx = 5;
% grid.mPerPx = 0.3e-03/5;
% grid.pxPerPeriod = 5;

% extrapOpts.FFDispPx = 5;
% extrapOpts.imageDef = false;
% padRadius = extrapOpts.dispPx;
% cropPx = extrapOpts.dispPx;
% padEdgeMethod = 'linear';
% fitWindow = 9; % not required for MATLAB default extrapolation

%% Extrapolate data to edges using linear extrapolation
% dispTemp = f_padDispArrayExt(pos,disp,grid,padRadius,padEdgeMethod,cropPx,fitWindow,extrapOpts); 
% dispCrop.x = func_cropFields(disp.x,2,extrapOpts.FFDispPx);
% dispCrop.x = func_fixNaNsInDispX(extrapOpts,dispCrop.x);
% 
% dispTemp = f_padDispArrayExt_XOnly(pos,dispCrop,grid,padRadius,extrapOpts.padEdgeMethod,extrapOpts.dispPx,extrapOpts.padFitWindow,extrapOpts);
% disp = dispTemp;
%%
% dispCrop.x = func_cropFields(disp.x,2,extrapOpts.FFDispPx);
% dispCrop.y = func_cropFields(disp.y,1,extrapOpts.FFDispPx);

% varTemp.x = func_fixNaNsInDispX(extrapOpts,varTemp.x);

m = mX; % 'FE' interp mesh density - x
n = mY; % 'FE' interp mesh density - y

[sy, sx, st] = size(varFit.x(range.y,range.x,:));

n_points = sy*sx; % number of measurement points

% dimensions of mesh based on cropped and padded vectors
L = max(pos.x) + min(pos.x);
W = max(pos.y) + min(pos.y);

L_el = L/m; % length of elements
W_el = W/n; % width of elements

% for fields cropped along columns (ux)
[pos.X,pos.Y] = meshgrid(pos.x,pos.y);

%reshape coordinate matrices and disp fields into vectors
X = reshape(pos.X, n_points,1);
Y = reshape(flipud(pos.Y), n_points,1);

%% Build Up Virtual Fields
% assign an element to each measurement point
iii = floor(X*m/L)+1; % elements in the x direction
jjj = floor(Y*n/W)+1; % elements in the y direction

%define parametric coordinates
xsi1 = 2*X/L_el - 2*iii +1; % along x direction
xsi2 = 2*Y/W_el - 2*jjj +1; % along y direction

% calculate virtual displacements
if strcmp(meshShapeFunctions,'linear')
    n_nodes = (m+1)*(n+1); % number of nodes - bilinear
    
    N = 0.25*[(1-xsi1).*(1-xsi2) (1+xsi1).*(1-xsi2) (1+xsi1).*(1+xsi2) (1-xsi1).*(1+xsi2)]; % bilinear quadrilateral
    % Define the nodes - bilinear quadrilateral
    n1 = (iii-1)*(n+1) + jjj; % first node
    n2 = iii*(n+1) + jjj; % second node
    n3 = iii*(n+1) + jjj +1; % third node
    n4 = (iii-1)*(n+1) + jjj +1; % fourth node 
    
    % matrix containing the degrees of freedom affected by each data point
    assemble = [n1 n2 n3 n4]; % bilinear quadrilateral
elseif strcmp(meshShapeFunctions,'quadratic')
    n_nodes = (2*m+1)*(2*n+1); % number of nodes - biquadratic
    
    N = [0.25*(xsi1-1).*(xsi2-1).*xsi1.*xsi2 0.25*(xsi1+1).*(xsi2-1).*xsi2.*xsi1 0.25*(xsi1+1).*(xsi2+1).*xsi2.*xsi1 ...
    0.25*(xsi1-1).*(xsi2+1).*xsi2.*xsi1 0.5*(1-xsi1.^2).*(xsi2-1).*xsi2 0.5*(xsi1+1).*(1-xsi2.^2).*xsi1 ...
    0.5*(1-xsi1.^2).*(xsi2+1).*xsi2 0.5*(xsi1-1).*(1-xsi2.^2).*xsi1 (1-xsi1.^2).*(1-xsi2.^2)]; % biquadratic quadrilateral

    % Define the nodes - biquadratic quadrilateral
    n1 = (2*iii-2)*(2*n+1) + 2*(jjj-1) + 1; % first node
    n2 = (2*iii)*(2*n+1) + 2*(jjj-1) + 1; % second node
    n5 = (2*iii-1)*(2*n+1) + 2*(jjj-1) +1; % fifth node
    n3 = n2 + 2; % third node
    n6 = n2 + 1; % sixth node
    n8 = n1 + 1; % eigth node
    n4 = n1 + 2; % fourth node
    n9 = n5 + 1; % ninth node (central)
    n7 = n5 + 2; % seventh node

    % matrix containing the degrees of freedom affected by each data point
    assemble = [n1 n2 n3 n4 n5 n6 n7 n8 n9]; % biquadratic quadrilateral
end

%% compute fitting for each frame
for i = 1:st
    % try with one frame
    ux = reshape(varFit.x(range.y,range.x,i), n_points,1);
    dE = reshape(mask(:,:,i), n_points,1);
    % uy = reshape(dispCrop.y(:,:,25), n_points,1);

    B = zeros(1,n_nodes);
    H = zeros(n_nodes, n_nodes);

    for k = 1:n_points
        assemble1 = assemble(k,:);
        if k > 1 && k < n_points && dE(k) ~= 0
            B(assemble1) = B(assemble1) + (ux(k)*N(k,:));
            % assemble Hessian matrix (minimization of error)
            H(assemble1,assemble1) = H(assemble1,assemble1) + N(k,:)'*N(k,:); % multiply actual strains by virtual strains
        end
    end
        
    % solve with least squares regression
    uS = H\B';

    %% reassemble virtual displacement field
    for k = 1:n_points
        % virtual displacement field
        u1vv = zeros(1,n_nodes);
        assemble1 = assemble(k,:);
        u1vv(assemble1) = N(k,:);
        u1va(k) = u1vv*uS; % for Q11
    end
    u1va = reshape(u1va,sy,sx);
    dispInterp.x(:,:,i) = u1va;
%     strainInterp.x(:,:,i) = gradient(u1va,grid.mPerPx,grid.mPerPx);
    clearvars u1va ux
end

for i = 1:st
    % try with one frame
    ux = reshape(varFit.y(range.y,range.x,i), n_points,1);
    % uy = reshape(dispCrop.y(:,:,25), n_points,1);

    B = zeros(1,n_nodes);
    H = zeros(n_nodes, n_nodes);

    for k = 1:n_points
        assemble1 = assemble(k,:);
        if k > 1 && k < n_points
            B(assemble1) = B(assemble1) + (ux(k)*N(k,:));
            % assemble Hessian matrix (minimization of error)
            H(assemble1,assemble1) = H(assemble1,assemble1) + N(k,:)'*N(k,:); % multiply actual strains by virtual strains
        end
    end
        
    % solve with least squares regression
    uS = H\B';

    %% reassemble virtual displacement field
    for k = 1:n_points
        % virtual displacement field
        u1vv = zeros(1,n_nodes);
        assemble1 = assemble(k,:);
        u1vv(assemble1) = N(k,:);
        u1va(k) = u1vv*uS; % for Q11
    end
    u1va = reshape(u1va,sy,sx);
    dispInterp.y(:,:,i) = u1va;
%     strainInterp.x(:,:,i) = gradient(u1va,grid.mPerPx,grid.mPerPx);
    clearvars u1va ux
end