[sy,sx,st] = size(accel.x);

for i = 1:time.numFrames % loop through number of frames
       
    for j = 1:sx % loop through each position on the specimen
        stress.SGx(i,j) = mean(mean(accel.x(:,1:j,i)))*j*pos.xStep*material.rho; % line average of reconstructed stress using stress gauge approach
        strain.xnyAvg(i,j) = mean(mean(strain.x(:,j,i)+ material.nuyx*strain.y(:,j,i))); % no uniaxial stress assumption
        strain.xAvg(i,j) = mean(mean(strain.x(:,j,i))); % uniaxial stress assumption
    end
    for j = 1:sy % loop through each position on the specimen
        stress.SGxy(i,j) = nanmean(nanmean(accel.x(1:j,:,i)))*j*pos.yStep*material.rho; % line average of reconstructed stress using stress gauge approach
        stress.SGyy(i,j) = mean(mean(accel.y(1:j,:,i)))*j*pos.yStep*material.rho; % line average of reconstructed stress using stress gauge approach
        strain.xyAvg(i,j) = mean(mean(strain.s(j,:,i))); % no uniaxial stress assumption
        strain.yAvg(i,j) = mean(mean(strain.y(j,:,i))); % uniaxial stress assumption
    end
end
%%
posInd = 150;
timeInd = 128;
% plot stress-strain curve
figure('color',[1 1 1])
plot(strain.xyAvg(1:timeInd,posInd)*1e03,stress.SGxy(1:timeInd,posInd)/1e06)
% grid on
xlabel('$$\overline{\epsilon_{xy}}^{x} (mm\cdot m^{-1}$$)','Interpreter','latex')
ylabel('$$\overline{\sigma_{xy}}^{x}$$ (MPa)','Interpreter','latex')
set(gca,'TickLabelInterpreter','latex','linewidth',1,'FontSize',16)

% plot stress-strain curve
figure('color',[1 1 1])
plot(strain.xAvg(1:timeInd,posInd)*1e03,stress.SGx(1:timeInd,posInd)/1e06)
% grid on
xlabel('$$\overline{\epsilon_{x}}^{x} (mm\cdot m^{-1}$$)','Interpreter','latex')
ylabel('$$\overline{\sigma_{xx}}^{x}$$ (MPa)','Interpreter','latex')
set(gca,'TickLabelInterpreter','latex','linewidth',1,'FontSize',16)