function fh = func_plotFrameMaps(plotParams,labelStrs,pos,time,plotVar)
% Author: Lloyd Fletcher
% PhotoDyn Group, University of Southampton
% Date: 13/3/2017
%
% Plots 2D frames of data 
% Inputs: 
% labelStrs.t - string giving the variable a name
% plotVar - 3D matrix, 3rd dim represents the frame number i.e. time         
% plotParams.frames - frame numbers to plot
myCMap = [0 0 143
0 0 159
0 0 175
0 0 191
0 0 207
0 0 223
0 0 239
0 0 255
5 12 254
9 24 253
14 35 252
19 47 251
24 59 250
29 71 249
34 83 247
38 95 246
43 107 245
48 119 244
53 131 243
58 142 242
62 154 241
67 166 240
72 178 239
77 190 238
87 189 225
97 188 212
107 187 199
117 187 186
127 186 173
137 185 161
147 184 148
157 183 135
167 183 122
177 182 109
187 181 96
197 180 83
207 179 70
217 179 58
227 178 45
237 177 32
238 166 30
239 155 28
240 144 26
241 133 24
243 122 22
244 110 20
245 99 18
246 88 16
247 77 14
248 66 12
249 55 10 
250 44 8 
251 33 6 
253 22 4 
254 11 2 
255 0 0
239 0 0
223 0 0
207 0 0
191 0 0
175 0 0
159 0 0
143 0 0
128 0 0];    
% Create a struct of formatting properties for the figure
plotProps = func_initPlotPropsStruct();

% Specify the range of data points to plot on the image
if isfield(plotParams,'cutEdgePx')
    if plotParams.cutEdgePx
        rangeX = (plotParams.cutPxX+1):size(plotVar,2)-plotParams.cutPxX;
        rangeY = (plotParams.cutPxY+1):size(plotVar,1)-plotParams.cutPxY;
    else
        rangeX = 1:size(plotVar,2);
        rangeY = 1:size(plotVar,1);
    end
else
    rangeX = 1:size(plotVar,2);
    rangeY = 1:size(plotVar,1);
end

% Check that the specificed frames to plot actually exist
[~,~,totalFrames] = size(plotVar);
numPlots = length(plotParams.frames);   
checkFrames = sum(plotParams.frames>totalFrames);
if checkFrames > 0
    error('Frame specified in plotParams.frames does not exist in plotVar')
    return
end

% Calculate the colorbar range for each variable to be plotted
if isfield(plotParams,'cAxisType')  
    plotParams.cRange{1} = func_calcColourBarRange(plotParams.cAxisType,...
        plotVar(rangeY,rangeX,:));
end

% Create and size the figure
fh = figure;
set(fh,'Position', [plotProps.locX,plotProps.locY,...
    plotParams.Cols*plotProps.sizePerFigX,plotParams.Rows*plotProps.sizePerFigY])
set(fh,'PaperPositionMode','auto')
for i = 1:numPlots
    hold on
    subplot(plotParams.Rows,plotParams.Cols,i)
    imagesc(pos.x(rangeX),pos.y(rangeY),squeeze(plotVar(rangeY,rangeX,plotParams.frames(i))))
    titleStr = {labelStrs.t,['Frame: ',num2str(plotParams.frames(i)),...
        ', Time: ',num2str(time.vec(plotParams.frames(i))*10^6,3)]};
    title(titleStr,'fontsize',plotProps.hfs,'fontname',plotProps.ft)
    set(gca,'fontsize',plotProps.fs,'fontname',plotProps.ft)
    colorbar
    colormap(myCMap)
    % Determine the colour bar range
    if isfield(plotParams,'cAxisType')
        if ~strcmp(plotParams.cAxisType,'Auto')
            if isfield(plotParams,'cRange')
                caxis(plotParams.cRange{1})
            end
        end
    end
    % Remove the image axes if required
    axis image
    if ~plotParams.imageAxis
        axis off
    else
        xlabel(labelStrs.x,'fontsize',plotProps.hfs,'fontname',plotProps.ft);
        ylabel(labelStrs.y,'fontsize',plotProps.hfs,'fontname',plotProps.ft);
    end
    hold off
end
end

