function VFs = func_VFDynInitManIsoLinElas(pos)
% Author: Lloyd Fletcher
% PhotoDyn Group, University of Southampton
% Date: 13/9/2017
%
% Creates two virtual fields for stiffness identification in a linear
% elastic isotropic material

% Geometric Variables to create the fields
pos.L = length(pos.x)*pos.xStep;
pos.H = length(pos.y)*pos.yStep;
L = pos.L;
H = pos.H;
x = pos.xGrid;
y = pos.yGrid;

% First Virtual Field
VFs{1}.uX = L-x;
VFs{1}.uY = zeros(size(x));
VFs{1}.epsXX = -1.*ones(size(x));
VFs{1}.epsYY = zeros(size(x));
VFs{1}.epsXY = zeros(size(x));

% Second Virtual Field
VFs{2}.uX = zeros(size(x));
VFs{2}.uY = (L-x).*(y/H);
VFs{2}.epsXX = zeros(size(x));
VFs{2}.epsYY = (L-x)./H;
VFs{2}.epsXY = -y./H;


end

