function [disp,strain] = func_avgFFDataOverWidth(time,disp,strain)
% Averages full field data over the width and returns new fields in the
% disp and strain struct with this information

    for i = 1:time.numFrames
        for x = 1:size(disp.x,2)
            % average disp at a particular slice (i.e. on an 'x' line)
            disp.xAvg(x,i) = nanmean(nanmean(disp.x(:,x,i))); 
            % average strain at a particular slice (i.e. on an 'x' line)
            strain.xAvg(x,i) = nanmean(nanmean(strain.x(:,x,i)));
            strain.yAvg(x,i) = nanmean(nanmean(strain.y(:,x,i)));
            strain.sAvg(x,i) = nanmean(nanmean(strain.s(:,x,i)));
        end
    end
end

