function [strainRate,strain] = func_calculateStrainRate(strain,time,smoothingOpts)
% Author: Jared Van Blitterswyk
% PhotoDyn Group, University of Southampton
% Date: 23/03/2017
% Edited By: Lloyd Fletcher
% This function takes in previously smoothed strain maps and computes
% returns full-field strain maps in the struct: 'strainRate'

    % perform full-field temporal smoothing using sliding window polynomial
    if smoothingOpts.FFTempSmooth
        strain.xtSmooth = func_reshapeAndGolayFilt3D(strain.x,smoothingOpts);
    end

    % compute strain rate
    if smoothingOpts.FFTempSmooth
        [~,~,strainRate.x] = gradient(strain.xtSmooth,1,1,time.step);
    else
        [~,~,strainRate.x] = gradient(strain.x,1,1,time.step);
    end

end