function [freeEdge,disp] = func_getFreeEdge(imagePath,imageFile,disp)
% Author: Lloyd Fletcher
% PhotoDyn Group, University of Southampton
% Date: 9/3/2017
%
% Determines which side of the reference image contains the free edge of
% the specimen for stress gauge processing

    % Create the plot properties structure
    plotProps = func_initPlotPropsStruct();

    % Load the reference image into memory
    refImage = imread([imagePath,imageFile]);

    % Show the first image in the sequence
    fh = figure;
    set(fh,'Position', [plotProps.locX,plotProps.locY,...
        2*plotProps.sizePerFigX,2*plotProps.sizePerFigY])
    set(fh,'PaperPositionMode','auto')
    imshow(refImage, []);

    % Ask the user which side the free edge is on using question dialogue
    freeEdge = questdlg('Which edge is the free edge on?', ...
        'Select free edge','Left','Right','Left');

    % Close the image
    clf(fh);
    close(fh);

    if strcmp(freeEdge,'Right')
        % If the free edge is on the right hand side flip the displacement
        % matrix left to right
        fprintf('Free edge is on the right hand side, flipping displacement matrices\n')
        for f = 1:size(disp.x,3)
            disp.x(:,:,f) = -fliplr(disp.x(:,:,f));
            disp.y(:,:,f) = fliplr(disp.y(:,:,f));
        end
    elseif strcmp(freeEdge,'Left')
        fprintf('Free edge is on the left hand side, no correction required.\n')
    end

end