function identStiffness = func_identQxxFromStressStrainCurve(identOpts,stress,strain)
% Author: Lloyd Fletcher
% PhotoDyn Group, University of Southampton
% Date: 9/3/2017
%
% Identifies Qxx by linearly fitting the stress-strain curves obtained from
% processing with the stress gauge approach
    
    % Select use of uniaxial assumption to fit stress strain curve
    if identOpts.method == 2
        strainToFit = strain.xnyAvg;
    else
        strainToFit = strain.xAvg;
    end
    
    % Use the fracture frame to determine how much of the stress strain
    % curve to fit
    if identOpts.fitCompOnly  
        for x = 1:size(stress.xAvg,1)
            [~,minInd] = min(stress.xAvg(x,:));
            tRange{x} = 1:minInd;
        end
    else
        for x = 1:size(stress.xAvg,1)
            tRange{x} = identOpts.defaultRange;
        end
    end
    
    % Specify algorithm for linear fit
    options = fitoptions('Method','LinearLeastSquares','Robust','Off');
    
    % Pre-alloc Qxx vars for speed
    QxxFit = cell(1,size(stress.xAvg,1));
    QxxGOF = cell(1,size(stress.xAvg,1));
    Qxx = zeros(1,size(stress.xAvg,1));
    
    % Loop over the length and linearly fit the stress strain curves
    for x = 1:size(stress.xAvg,1)
       % Make sure there are enough points to linearly fit
       if length(tRange{x}) >= 2
           [QxxFit{x},QxxGOF{x}] = fit(strainToFit(x,tRange{x})',...
               stress.xAvg(x,tRange{x})','poly1',options); 
           identStiffness.QxxVsL(x) = QxxFit{x}.p1;
           identStiffness.linearFitCoeffs{x} = [QxxFit{x}.p1,QxxFit{x}.p2];
       else
           % If there are not enough points return 0 stiffness
           identStiffness.QxxVsL(x) = 0;
           identStiffness.linearFitCoeffs{x} = [0,0];
       end
    end  
end

