function plotProps = func_initPlotPropsStruct(typeStr)

    if nargin == 0
        typeStr = 'other';
    end

    plotProps.screenSize = get(groot,'Screensize');
    plotProps.units = 'pixels';
    % Creates a data struct for plot properties
    if strcmp(typeStr,'presentation')
        plotProps.format = '-dpng';       % File format for image saving
        plotProps.locX = 0;            % Image location in pixels 
        plotProps.locY = 50;            % Image location in pixels 
        plotProps.ratio = 1.618; 
        plotProps.sizeY = 450;           % Image edge size in pixels
        plotProps.sizeX = plotProps.sizeY*plotProps.ratio;
        plotProps.sizePerFigX = plotProps.screenSize(3)/4;
        plotProps.sizePerFigY =  plotProps.sizePerFigX/plotProps.ratio;
        plotProps.lw = 1;            % plot line width 
        plotProps.ms = 7;               % marker size for plots 
        plotProps.ft = 'arial';         % font for figures 
        plotProps.fs = 20;
        plotProps.hfs = 22;
        
    elseif strcmp(typeStr,'article')
        plotProps.format = '-depsc';       % File format for image saving
        plotProps.locX = 0;            % Image location in pixels 
        plotProps.locY = 0;            % Image location in pixels 
        plotProps.ratio = 2.1; 
        plotProps.sizeY = 450;           % Image edge size in pixels
        plotProps.sizeX = plotProps.sizeY*plotProps.ratio;
        plotProps.sizePerFigX = plotProps.screenSize(3)/4;
        plotProps.sizePerFigY =  plotProps.sizePerFigX/plotProps.ratio;
        plotProps.sizePerFigXcm = 8;
        plotProps.sizePerFigYcm = plotProps.sizePerFigXcm/1.6;
        plotProps.lw = 0.05;            % plot line width 
        plotProps.ms = 3;               % marker size for plots 
        plotProps.ft = 'times';         % font for figures 
        plotProps.fs = 8;
        plotProps.hfs = 9;
        plotProps.titleWeight = 'normal';
        plotProps.units = 'centimeters';
        plotProps.sizeXcm = 18;
        plotProps.sizeYcm = plotProps.sizeXcm/plotProps.ratio;
        
    else
        plotProps.format = '-dpng';       % File format for image saving
        plotProps.locX = 0;            % Image location in pixels 
        plotProps.locY = 50;            % Image location in pixels
        plotProps.ratio = 1.618; 
        plotProps.sizeX = 700;           % Image edge size in pixels
        plotProps.sizeY = plotProps.sizeX/plotProps.ratio;
        plotProps.ratio = 1.618;        % Ratio of image height to width
        plotProps.sizePerFigX = plotProps.screenSize(3)/4;
        plotProps.sizePerFigY =  plotProps.sizePerFigX/plotProps.ratio;
        plotProps.lw = 1;            % plot line width 
        plotProps.ms = 4;               % marker size for plots 
        plotProps.ft = 'arial';         % font for figures 
        plotProps.fs = 11;
        plotProps.hfs = 13;
    end
    
    plotProps.lineStyleVec = {'-xb','-+r','-dk','-sg',':+b',':dr',':sk',':xg','-.xb','-.+r','-.dk','-.sg',};
    plotProps.lineStyleVec = [plotProps.lineStyleVec,plotProps.lineStyleVec,plotProps.lineStyleVec];
    plotProps.markerVec = {'ob','or','ok','og','ob','or','ok','og','ob','or','ok','og'};
    plotProps.letter = {'a','b','c','d','e','f','g','h','i','j','k','l','m','n'};
    plotProps.colour = {'b','r','g'};
    plotProps.marker = {'x','+','o','s','d','^'};
    plotProps.line = {'-','--','-.',':'};
    plotProps.singleLS = '-xb';
    
end

