function func_plotAllFullFieldVideos(plotParams,imagePath,pos,time,disp,...
    strain,strainRate,accel,plotRawStrain)
% Author: Lloyd Fletcher
% PhotoDyn Group, University of Southampton
% Date: 13/3/2017
%
% Plots 2D frames of data as an image sequence
    
    if nargin < 9
        plotRawStrain = true;
    end

    %plotParams.cAxisType = 'Specified';
    % Label strings for the image axis
    labelStrs.x = 'X (mm)';
    labelStrs.y = 'Y (mm)';

    %----------------------------------------------------------------------
    % Image Sequence of X Disp, Strain, Accel and Strain Rate
    
    % Create the save path for the heat maps
    imageSeqSavePath = [imagePath,'ImageSeq_DispAccelStrainStrainRateX\'];

    % Check if the image sequence path exits, if it does ask the user if it
    % needs to be plotted again
    if exist(imageSeqSavePath,'file') == 7
        choice = questdlg('Full-field image sequence folder found, plot again?', ...
        'Plot Image Sequence?', 'Yes','No','No');
        switch choice
            case 'Yes'
                plotImageSeq = true;
            case 'No'
                plotImageSeq = false;
        end
    else
        % If the directory does not exist, create it and plot the image seq
        mkdir(imageSeqSavePath);
        plotImageSeq = true;
    end
    
    if plotImageSeq
        % Create title strings and plot variables for the video
        labelStrs.t{1} = 'Displacement X, \delta_{x}, (mm)';
        labelStrs.t{2} = 'Accel X, a_{x}, (m.s^{-2})';
        labelStrs.t{3} = 'Strain X, \epsilon_{x}, (mm.m^{-1})';
        labelStrs.t{4} = 'Strain Rate X, d\epsilon_{x}/dt, (s^{-1})';
        % Assign the different variables to be plotted
        [deformDisp,rigidDisp] = func_calcDispRemoveRigidBody(disp.x);
        plotVars{1} = deformDisp*10^3;
        plotVars{2} = accel.x;
        plotVars{3} = strain.x*10^3;
        plotVars{4} = strainRate.x;
        % Specify the parameters of the plot
        plotParams.Rows = 2;
        plotParams.Cols = 2;
        plotParams.titleFrameNum = true;
        plotParams.cRange{1} = plotParams.cAxisDisp;
        plotParams.cRange{2} = plotParams.cAxisAccel;
        plotParams.cRange{3} = plotParams.cAxisStrain;
        plotParams.cRange{4} = plotParams.cAxisStrainRate;
        % Plot and save the image sequence to file
        func_plotFullFieldImageSeq(imageSeqSavePath,plotParams,labelStrs,pos,time,plotVars)
        
    end
    
    if plotRawStrain
        %----------------------------------------------------------------------
        % Image Sequence of X Disp, Strain, Raw Strain and Strain Rate

        % Create the save path for the heat maps
        imageSeqSavePath = [imagePath,'ImageSeq_RawStrainX\'];

        % Check if the image sequence path exits, if it does ask the user if it
        % needs to be plotted again
        if exist(imageSeqSavePath,'file') == 7
            choice = questdlg('Raw strain image sequence folder found, plot again?', ...
            'Plot Image Sequence?', 'Yes','No','No');
            switch choice
                case 'Yes'
                    plotImageSeq = true;
                case 'No'
                    plotImageSeq = false;
            end
        else
            % If the directory does not exist, create it and plot the image seq
            mkdir(imageSeqSavePath);
            plotImageSeq = true;
        end    

        if plotImageSeq
            % Calculate the RAW strains for plotting
            xStep = abs(pos.x(2) - pos.x(1));
            yStep = abs(pos.y(2) - pos.y(1));
            [rawStrain.x,~,~] = gradient(disp.x,xStep,yStep,time.step);
            [deformDisp,rigidDisp] = func_calcDispRemoveRigidBody(disp.x);
            % Create title strings and plot variables for the video
            labelStrs.t{1} = 'Displacement X, \delta_{x}, (mm)';
            labelStrs.t{2} = 'Accel X, a_{x}, (m.s^{-2})';
            labelStrs.t{3} = 'Raw Stain X, \epsilon_{x}, (mm.m^{-1})';
            labelStrs.t{4} = 'Strain Rate X, d\epsilon_{x}/dt, (s^{-1})';
            % Assign the different variables to be plotted
            plotVars{1} = deformDisp*10^3;
            plotVars{2} = accel.x;
            plotVars{3} = rawStrain.x*10^3;
            plotVars{4} = strainRate.x;
            % Specify the parameters of the plot
            plotParams.Rows = 2;
            plotParams.Cols = 2;
            plotParams.titleFrameNum = true;
            plotParams.cRange{1} = plotParams.cAxisDisp;
            plotParams.cRange{2} = plotParams.cAxisAccel;
            plotParams.cRange{3} = plotParams.cAxisRawStrain;
            plotParams.cRange{4} = plotParams.cAxisStrainRate;
            % Plot and save the image sequence to file
            func_plotFullFieldImageSeq(imageSeqSavePath,plotParams,labelStrs,pos,time,plotVars)
        end
    end
end