function  hf = func_plotNuVsTime(NuPlotOpts,time,material,identStiffness)
% Author: Lloyd Fletcher
% PhotoDyn Group, University of Southampton
% Date: 17/5/2017
%
% Plots the poisson's ratio identified by the VF vs time

% Get some plot parameters for nice formatting
plotProps = func_initPlotPropsStruct('presentation');

% Select the target value based on the method chosen
labelStrs.y = 'Poissons Ratio, \nu';
identAvg(1:time.numFrames) = identStiffness.NuxyAvgOverT;

% Setup the plotting vectors for the target and the error bounds
target(1:time.numFrames) = material.nuxy;
upperLim(1:time.numFrames) = material.nuxy*(1+NuPlotOpts.targPc);
lowerLim(1:time.numFrames) = material.nuxy*(1-NuPlotOpts.targPc);
axisLims = [0,time.vec(end)*10^6,NuPlotOpts.range(1),NuPlotOpts.range(2)];

% Setup the legend strings
if NuPlotOpts.plotAverage
    legendStrs{1} = 'Identified';
    legendStrs{2} = 'Identified Avg';
    legendStrs{3} = 'QS Ref';
    legendStrs{4} = ['QS Ref \pm',num2str(NuPlotOpts.targPc*100),'%'];
else
    legendStrs{1} = 'Identified';
    legendStrs{2} = 'QS Ref';
    legendStrs{3} = ['QS Ref \pm',num2str(NuPlotOpts.targPc*100),'%'];
end

hf = figure;
set(hf,'Position', [plotProps.locX,plotProps.locY,...
        2*plotProps.sizePerFigX,1.6*plotProps.sizePerFigY])
set(hf,'PaperPositionMode','auto')
labelStrs.x = 'Time, (\mus)';
hold on
plot(time.vec*10^6,identStiffness.NuxyVsT,'-xb','linewidth',plotProps.lw,'markersize',plotProps.ms)
if NuPlotOpts.plotAverage
    plot(time.vec*10^6,identAvg,'-.b','linewidth',plotProps.lw,'markersize',plotProps.ms)
end
plot(time.vec*10^6,target,'--k','linewidth',plotProps.lw,'markersize',plotProps.ms)
plot(time.vec*10^6,upperLim,'-k',time.vec*10^6,lowerLim,'-k','linewidth',plotProps.lw,'markersize',plotProps.ms)
xlabel(labelStrs.x,'fontsize',plotProps.hfs,'fontname',plotProps.ft)
ylabel(labelStrs.y,'fontsize',plotProps.hfs,'fontname',plotProps.ft)
set(gca, 'fontsize', plotProps.fs,'fontname',plotProps.ft)
set(gca,'XMinorTick','on','YMinorTick','on')
legend(legendStrs,'location','eastoutside')
axis(axisLims)
box on
grid on
hold off


end

