function func_plotPresentationVideos(plotParams,savePath,pos,time,...
    disp,strain,strainRate,accel,stress,identStiffness)
% Author: Lloyd Fletcher
% PhotoDyn Group, University of Southampton
% Date: 29/3/2017
%
% Plots image sequences used to create videos for power points presentations 

% If not specified then plot all of the image sequences
if ~isfield(plotParams,'imageSeqs')
     plotParams.imageSeqs = [1,1,1];
end

% Specify the color bar and pixel cutting options
plotParams.cAxisType = 'MaxQuantile';
% Label strings for the image axis
labelStrs.x = 'X (mm)';
labelStrs.y = 'Y (mm)';

% Create the save paths for the image sequences
imageSeqSavePath{1} = [savePath,'PresentationVid_DispAccelStrainStrainRateX\'];
imageSeqSavePath{2} = [savePath,'PresentationVid_Maps_SSCurve\'];
imageSeqSavePath{3} = [savePath,'PresentationVid_COMPONLY_Maps_SSCurve\'];
%imageSeqSavePath{4} = [savePath,'PresentationVid_SingleMap_SSCurve\'];
for p = 1:length(imageSeqSavePath)
    if exist(imageSeqSavePath{p},'file') ~= 7
        mkdir(imageSeqSavePath{p});
    end
end

%-------------------------------------------------------------------------
% Video 1: Accel Map and Strain Map
plotInd = 1;
if plotParams.imageSeqs(plotInd)
    fprintf('\tPlotting disp, accel, strain and strain rate maps.\n')
    % Create title strings and plot variables for the video
    labelStrs.t{1} = '\delta_{x} [mm]';
    labelStrs.t{2} = 'a_{x} [m.s^{-2}]';
    labelStrs.t{3} = '\epsilon_{x} [mm.m^{-1}]';
    labelStrs.t{4} = 'd\epsilon_{x}/dt [s^{-1}]';
    % Assign the different variables to be plotted
    [deformDisp,rigidDisp] = func_calcDispRemoveRigidBody(disp.x);
    plotVars{1} = deformDisp*10^3;
    plotVars{2} = accel.x;
    plotVars{3} = strain.x*10^3;
    plotVars{4} = strainRate.x;
    % Specify the parameters of the plot
    plotParams.Rows = 2;
    plotParams.Cols = 2;
    plotParams.cRange{1} = plotParams.cAxisDisp;
    plotParams.cRange{2} = plotParams.cAxisAccel;
    plotParams.cRange{3} = plotParams.cAxisStrain;
    plotParams.cRange{4} = plotParams.cAxisStrainRate;
    % Plot and save the image sequence to file
    func_plotFullFieldImageSeq(imageSeqSavePath{plotInd},plotParams,labelStrs,pos,time,plotVars)
end

%-------------------------------------------------------------------------
% Video 1: Strain Map and Stress Strain Curve
plotInd = 2;
if plotParams.imageSeqs(plotInd)
    fprintf('\tPlotting stress-strain curve and variable maps for full time range.\n')
    plotParams.Rows = 2;
    plotParams.Cols = 2;
    ssCurveLoc = plotParams.ssCurveLoc;

    plotTrendLine = false;
    func_plotMapsAndSSCurve(imageSeqSavePath{plotInd},plotParams,labelStrs,pos,time,...
       ssCurveLoc,plotParams.ssCurveMethod,stress,strain,accel,strainRate,plotTrendLine,identStiffness)
end

%-------------------------------------------------------------------------
% Video 2: Strain Map and Stress Strain Curve
plotInd = 3;
if plotParams.imageSeqs(plotInd)
    fprintf('\tPlotting stress-strain curve and variable maps for compression loading only.\n')
    plotParams.Rows = 2;
    plotParams.Cols = 2;
    ssCurveLoc = plotParams.ssCurveLoc;
    [~,endFrame] = min(squeeze(stress.xAvg(ssCurveLoc,:)));
    plotParams.tRange = 1:endFrame;
    plotTrendLine = true;
    func_plotMapsAndSSCurve(imageSeqSavePath{plotInd},plotParams,labelStrs,pos,time,...
        ssCurveLoc,plotParams.ssCurveMethod,stress,strain,accel,strainRate,plotTrendLine,identStiffness);
end

%-------------------------------------------------------------------------
% Video ?: Strain Map and Stress Strain Curve
%{
fprintf('\tPlotting stress-strain curve and single variable map.\n')
plotParams.Rows = 1;
plotParams.Cols = 2;
% Create title strings and plot variables for the video
labelStrs.t{1} = '\epsilon_{x} (mm.m^{-1})';
plotParams.cRange{1} = [-20,20];
plotParams.tRange = 1:(time.numFrames-5);
mapVar = strain.x*10^3;
% Label strings for the image axis
labelStrs = rmfield(labelStrs,'x');
labelStrs = rmfield(labelStrs,'y');
labelStrs.x{1} = 'X (mm)';
labelStrs.y{1} = 'Y (mm)';
if plotParams.ssCurveMethod == 1
labelStrs.x{2} = '\epsilon_{x} (mm.m^{-1})';
else
labelStrs.x{2} = '\epsilon_{x}+\nu\epsilon_{y} (mm.m^{-1})';
end
labelStrs.y{2} = '\sigma_{x} (MPa)';
ssCurveInd = round(length(pos.x)/2);
func_plotMapAndSSCurve(imageSeqSavePath{4},plotParams,labelStrs,pos,time,mapVar,ssCurveInd,plotParams.ssCurveMethod,stress,strain)
%}

end

